+++
title = "htmx 1.0.0 has been released!"
date = 2020-11-24
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 1.0.0 Release

I'm happy to announce the [1.0.0 release](https://unpkg.com/browse/htmx.org@1.0.0/) of htmx.

htmx is now mature enough that I can recommend it as a general replacement for intercooler.js
projects.  I **don't** think there is a strong reason to port an existing intercooler project to
htmx.  I have several large intercooler apps and will not be moving them over any time soon. I can, however, recommend using htmx over intercooler for new projects.

htmx is a different sort of javascript library.  It is an HTML & hypertext-oriented reply to the current dominance of javascript-based SPA libraries.  It is a response to Tom MacWright's question:
["If not SPAs, What?"](https://macwright.com/2020/10/28/if-not-spas.html).

As the [homepage says](@/_index.md):

* Why should only `<a>` and `<form>` be able to make HTTP requests?
* Why should only `click` & `submit` events trigger them?
* Why should only GET & POST be available?
* Why should you only be able to replace the entire screen?

HTML-oriented web development was abandoned not because hypertext was a bad idea, but rather because HTML didn't have sufficient expressive power.  htmx aims to fix that & allows you to implement [many common modern web UI patterns](@/examples/_index.md) using the original hypertext model of the web.
 
### History & Thanks

htmx began life as [intercooler.js](https://intercoolerjs.org) back in [2013](https://github.com/bigskysoftware/intercooler-js/commit/62d3dbdb5c056ee866aba3575e148de649fc3efe).

In [april](https://github.com/bigskysoftware/htmx/commit/e38dea64dd1065003a0e833d7b469d24e6bc2919) of this year I began work on a jQuery-independent & improved version of intercoolerjs, renamed
to htmx.  I chose to rename the library because, in working on intercooler, I had come to appreciate that intercooler & htmx were completing HTML as a hypertext rather than just some funky, idiosyncratic javascript libraries.
  
In [May](https://github.com/bigskysoftware/htmx/releases/tag/v0.0.1) htmx reached 0.0.1.  Soon thereafter I had the good fortune of being contacted by [Ben Croker](https://twitter.com/ben_pylo)
who was interested in htmx as a base for his new reactive library, [Sprig](https://putyourlightson.com/plugins/sprig).  Ben was willing to be an early adopter of htmx and pushed the library along
much faster than it would have gone otherwise.

I have been very lucky to the have help and feedback from many contributors in [GitHub](https://github.com/bigskysoftware/htmx/graphs/contributors) and on [Discord](https://htmx.org/discord).  I'd like to thank, in particular, [Ben Pate](https://github.com/benpate), [Robert Schroll](https://github.com/rschroll) & [Alejandro Schmeichler](https://github.com/jreviews) for contributing code as well as new ideas and discussions.

I would like to thank [Devmode.fm](https://devmode.fm/) for having me on to [talk about htmx](https://devmode.fm/episodes/dynamic-html-with-htmx) and for cleaning up all my "uhhs" and "umms".  

Finally, I would like to thank [Justin Sampson](https://github.com/jsampson), who took a lot of time to explain REST & HATEOAS to me and how intercooler (and now htmx) fit into that model for web development.

### Changes

* I bumped the version number :)

Enjoy!
