// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the MIT license.  See License.txt in the project root for license information.

namespace Microsoft.NetFramework.Analyzers
{
    /// <summary>
    /// Specifies the member names used by security analyzers
    /// </summary>
    public static class SecurityMemberNames
    {
        public const string Create = "Create";
        public const string Load = "Load";
        public const string LoadXml = "LoadXml";
        public const string Read = "Read";
        public const string ReadXml = "ReadXml";
        public const string ReadXmlSchema = "ReadXmlSchema";
        public const string Deserialize = "Deserialize";
        public const string InnerXml = "InnerXml";
        public const string DataViewSettingCollectionString = "DataViewSettingCollectionString";
        public const string DtdProcessing = "DtdProcessing";
        public const string Parse = "Parse";
        public const string XmlResolver = "XmlResolver";
        public const string TrustedXslt = "TrustedXslt";
        public const string Default = "Default";
        public const string EnableDocumentFunction = "EnableDocumentFunction";
        public const string EnableScript = "EnableScript";
        public const string MaxCharactersFromEntities = "MaxCharactersFromEntities";
    }
}