use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 4, need 'ssl';

# This test case attempts only one type of attack which is possible
# due to the TLS renegotiation vulnerability, CVE-2009-3555.  A
# specific defense against this attack was added to mod_ssl in
# r891282.  For more information, see the dev@httpd thread beginning
# at message ID <4B01BD20.1060300@adnovum.ch>.

Apache::TestRequest::set_client_cert("client_ok");

Apache::TestRequest::module('mod_ssl');

my $sock = Apache::TestRequest::vhost_socket('mod_ssl');

if ($sock && $sock->connected && $sock->get_sslversion() eq "TLSv1_3") {
    skip "Skipping test for TLSv1.3" foreach(1..4);
    exit;
}

ok $sock && $sock->connected;


my $req = "GET /require/asf/ HTTP/1.1\r\n".
   "Host: " . Apache::TestRequest::hostport() . "\r\n".
    "\r\n".
    "GET /this/is/a/prefix/injection/attack HTTP/1.0\r\n".
    "Host: " . Apache::TestRequest::hostport() . "\r\n".
    "\r\n";

ok $sock->print($req);

my $line = Apache::TestRequest::getline($sock) || '';

ok t_cmp($line, qr{^HTTP/1\.. 200}, "read first response-line");

my $rv = 0;

do {
    $line = Apache::TestRequest::getline($sock) || '';
    $line = super_chomp($line);
    print "# line: $line\n";
    if ($line eq "Connection: close") {
        $rv = 1;
    }
} until ($line eq "");

ok $rv, 1, "expected Connection: close header in response";

sub super_chomp {
    my ($body) = shift;

    ## super chomp - all leading and trailing \n (and \r for win32)
    $body =~ s/^[\n\r]*//;
    $body =~ s/[\n\r]*$//;
    ## and all the rest change to spaces
    $body =~ s/\n/ /g;
    $body =~ s/\r//g; #rip out all remaining \r's

    $body;
}
