/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFManager
implements Monitor {
    private Hashtable<Integer, NTFListener> nsListeners;
    private Hashtable<Integer, NTFRegistration> ntfRegistrations;
    private ConcurrentHashMap<Long, NTFDCNRegistration> dcnRegistrations;
    private byte[] listOfJdbcRegId;
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId;
    private HashMap<String, NTFJMSConnectionGroup> jmsConnectionGroups;
    private HashMap<String, NTFDCNConnectionGroup> dcnConnectionGroups;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    NTFManager() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NTFManager.class, $$$methodRef$$$18, null, new Object[0]);
            }
            this.nsListeners = new Hashtable();
            this.ntfRegistrations = new Hashtable();
            this.dcnRegistrations = new ConcurrentHashMap();
            this.listOfJdbcRegId = new byte[20];
            this.jmsRegIdToJDBCRegId = new HashMap();
            this.jmsConnectionGroups = new HashMap();
            this.dcnConnectionGroups = new HashMap();
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NTFManager.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTFManager.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTFManager.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean listenOnPortT4C(int[] nArray, boolean bl, @Blind(value=PropertiesBlinder.class) Properties properties, Exception[] exceptionArray) throws SQLException {
        boolean bl2 = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl3;
            block31: {
                Monitor.CloseableLock lock;
                block32: {
                    if (bl2) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, nArray, bl, TraceControllerImpl.blind(PropertiesBlinder.class, properties), exceptionArray);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void portArr;
                        void tryPort = portArr[0];
                        boolean newListenerThreadCreated = false;
                        while (true) {
                            void connectionCreationExceptionArr;
                            NTFListener listener;
                            if ((listener = this.nsListeners.get((int)tryPort)) != null) {
                                if (connectionCreationExceptionArr != null && ((void)connectionCreationExceptionArr).length > 0) {
                                    Exception ioe;
                                    connectionCreationExceptionArr[0] = ioe = listener.getRegistrationException();
                                }
                                if (!bl2) break;
                                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFManager (tcpport=" + (int)tryPort + ") already listening");
                                break;
                            }
                            try {
                                void force;
                                ServerSocketChannel ssChannel = ServerSocketChannel.open();
                                ssChannel.configureBlocking(false);
                                ServerSocket serverSocket = ssChannel.socket();
                                InetSocketAddress isa = new InetSocketAddress((int)tryPort);
                                try {
                                    void socketOptions;
                                    serverSocket.bind(isa);
                                    newListenerThreadCreated = true;
                                    listener = new NTFListener(this, ssChannel, (int)tryPort, (Properties)socketOptions, (Exception[])connectionCreationExceptionArr);
                                    this.nsListeners.put((int)tryPort, listener);
                                    listener.start();
                                    if (!bl2) break;
                                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFManager (tcpport=" + (int)tryPort + ") started listener, socketOptions: " + socketOptions);
                                    break;
                                }
                                catch (BindException be) {
                                    if (force == false) {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250).fillInStackTrace();
                                        if (bl2) {
                                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    serverSocket.close();
                                    ++tryPort;
                                }
                                catch (IOException iox2) {
                                    if (force == false) {
                                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250).fillInStackTrace();
                                        if (bl2) {
                                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, sQLException);
                                        }
                                        throw sQLException;
                                    }
                                    serverSocket.close();
                                    ++tryPort;
                                }
                            }
                            catch (IOException ioe) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                                if (bl2) {
                                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, sQLException);
                                }
                                throw sQLException;
                            }
                        }
                        portArr[0] = tryPort;
                        bl3 = newListenerThreadCreated;
                        if (lock == null) break block31;
                        if (throwable == null) break block32;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl2) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block31;
                }
                lock.close();
            }
            boolean bl4 = bl3;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFManager.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getNextJdbcRegId() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int off;
                        for (off = 1; off < this.listOfJdbcRegId.length && this.listOfJdbcRegId[off] != 0; ++off) {
                        }
                        if (off == this.listOfJdbcRegId.length - 1) {
                            byte[] listOfJdbcRegId2 = new byte[this.listOfJdbcRegId.length * 2];
                            System.arraycopy(this.listOfJdbcRegId, 0, listOfJdbcRegId2, 0, this.listOfJdbcRegId.length);
                            this.listOfJdbcRegId = listOfJdbcRegId2;
                        }
                        this.listOfJdbcRegId[off] = 2;
                        n2 = off;
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFManager.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addRegistration(NTFRegistration nTFRegistration) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this, nTFRegistration);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void registration;
                        Integer key = registration.getJdbcRegId();
                        Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
                        ntfRegistrations2.put(key, registration);
                        this.ntfRegistrations = ntfRegistrations2;
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFManager.class, $$$methodRef$$$2, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeRegistration(NTFRegistration nTFRegistration) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, nTFRegistration);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void registration;
                        Integer key = registration.getJdbcRegId();
                        Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
                        Object obj = ntfRegistrations2.remove(key);
                        this.ntfRegistrations = ntfRegistrations2;
                        boolean ret = false;
                        if (obj != null) {
                            ret = true;
                        }
                        bl2 = ret;
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            boolean bl3 = bl2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFManager.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void freeJdbcRegId(int n2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this, n2);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void jdbcRegId;
                        if (this.listOfJdbcRegId != null && this.listOfJdbcRegId.length > jdbcRegId) {
                            this.listOfJdbcRegId[jdbcRegId] = 0;
                        }
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFManager.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cleanListenersT4C(int n2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block22: {
                Monitor.CloseableLock lock;
                block23: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this, n2);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        NTFListener listener;
                        void tcpport;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFManager (tcpport=" + (int)tcpport + ") cleaning listener");
                        }
                        Enumeration<Integer> keys = this.ntfRegistrations.keys();
                        boolean portUsed = false;
                        while (!portUsed && keys.hasMoreElements()) {
                            Integer localkey = keys.nextElement();
                            NTFRegistration reg = this.ntfRegistrations.get(localkey);
                            if (reg.getClientTCPPort() != tcpport) continue;
                            portUsed = true;
                        }
                        if (!portUsed && (listener = this.nsListeners.get((int)tcpport)) != null) {
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFManager (tcpport=" + (int)tcpport + ") closing listener");
                            }
                            listener.closeThisListener();
                            listener.interrupt();
                            this.nsListeners.remove((int)tcpport);
                        }
                        if (lock == null) break block22;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block22;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFManager.class, $$$methodRef$$$5, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFRegistration getRegistration(int n2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            NTFRegistration obj;
            void jdbcRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFManager.class, $$$methodRef$$$6, this, n2);
            }
            Integer key = (int)jdbcRegId;
            Hashtable<Integer, NTFRegistration> localHandle = this.ntfRegistrations;
            NTFRegistration nTFRegistration = obj = localHandle.get(key);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFManager.class, $$$methodRef$$$6, this, nTFRegistration);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFManager.class, $$$methodRef$$$6, this, null);
            }
            return nTFRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFManager.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFManager.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFManager.class, $$$methodRef$$$7, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFManager.class, $$$methodRef$$$7, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFManager.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void removeJMSRegistrationId(Long l2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegistrationId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFManager.class, $$$methodRef$$$8, this, l2);
            }
            this.jmsRegIdToJDBCRegId.remove(jmsRegistrationId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFManager.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFManager.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFManager.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int getJDBCRegId(Long l2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegistrationId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFManager.class, $$$methodRef$$$9, this, l2);
            }
            int n2 = this.jmsRegIdToJDBCRegId.get(jmsRegistrationId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFManager.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFManager.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFManager.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void mapJMSRegIdToJDBCRegId(Long l2, int n2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void jdbcRegistrationId;
            void jmsRegistrationId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFManager.class, $$$methodRef$$$10, this, l2, n2);
            }
            this.jmsRegIdToJDBCRegId.put((Long)jmsRegistrationId, (int)jdbcRegistrationId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFManager.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFManager.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFManager.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NTFJMSConnectionGroup getJMSConnectionGroup(String string) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            NTFJMSConnectionGroup nTFJMSConnectionGroup;
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void key;
                        NTFJMSConnectionGroup newObject = this.jmsConnectionGroups.get(key);
                        if (newObject == null) {
                            newObject = new NTFJMSConnectionGroup((String)key);
                        }
                        this.jmsConnectionGroups.put((String)key, newObject);
                        nTFJMSConnectionGroup = newObject;
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            NTFJMSConnectionGroup nTFJMSConnectionGroup2 = nTFJMSConnectionGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, nTFJMSConnectionGroup2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, null);
            }
            return nTFJMSConnectionGroup2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFManager.class, $$$methodRef$$$11, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeJMSConnectionGroup(String string) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void key;
                        this.jmsConnectionGroups.remove(key);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFManager.class, $$$methodRef$$$12, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NTFDCNConnectionGroup getDCNConnectionGroup(String string) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            NTFDCNConnectionGroup nTFDCNConnectionGroup;
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void key;
                        NTFDCNConnectionGroup newObject = this.dcnConnectionGroups.get(key);
                        if (newObject == null) {
                            newObject = new NTFDCNConnectionGroup((String)key);
                        }
                        this.dcnConnectionGroups.put((String)key, newObject);
                        nTFDCNConnectionGroup = newObject;
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            NTFDCNConnectionGroup nTFDCNConnectionGroup2 = nTFDCNConnectionGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, nTFDCNConnectionGroup2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, null);
            }
            return nTFDCNConnectionGroup2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFManager.class, $$$methodRef$$$13, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeDCNConnectionGroup(String string) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this, string);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void key;
                        this.dcnConnectionGroups.remove(key);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFManager.class, $$$methodRef$$$14, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addDCNRegistration(NTFDCNRegistration nTFDCNRegistration) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void registration;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NTFManager.class, $$$methodRef$$$15, this, nTFDCNRegistration);
            }
            this.dcnRegistrations.put(registration.getRegId(), (NTFDCNRegistration)registration);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NTFManager.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFManager.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFManager.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFDCNRegistration getDCNRegistration(long l2) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void regId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NTFManager.class, $$$methodRef$$$16, this, l2);
            }
            NTFDCNRegistration nTFDCNRegistration = this.dcnRegistrations.get((long)regId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NTFManager.class, $$$methodRef$$$16, this, nTFDCNRegistration);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTFManager.class, $$$methodRef$$$16, this, null);
            }
            return nTFDCNRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTFManager.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NTFManager.class, $$$methodRef$$$17, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NTFManager.class, $$$methodRef$$$17, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTFManager.class, $$$methodRef$$$17, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTFManager.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$18 = NTFManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NTFManager.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NTFManager.class.getDeclaredMethod("getDCNRegistration", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NTFManager.class.getDeclaredMethod("addDCNRegistration", NTFDCNRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NTFManager.class.getDeclaredMethod("removeDCNConnectionGroup", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFManager.class.getDeclaredMethod("getDCNConnectionGroup", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFManager.class.getDeclaredMethod("removeJMSConnectionGroup", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFManager.class.getDeclaredMethod("getJMSConnectionGroup", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFManager.class.getDeclaredMethod("mapJMSRegIdToJDBCRegId", Long.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFManager.class.getDeclaredMethod("getJDBCRegId", Long.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFManager.class.getDeclaredMethod("removeJMSRegistrationId", Long.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFManager.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFManager.class.getDeclaredMethod("getRegistration", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFManager.class.getDeclaredMethod("cleanListenersT4C", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFManager.class.getDeclaredMethod("freeJdbcRegId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFManager.class.getDeclaredMethod("removeRegistration", NTFRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFManager.class.getDeclaredMethod("addRegistration", NTFRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFManager.class.getDeclaredMethod("getNextJdbcRegId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFManager.class.getDeclaredMethod("listenOnPortT4C", int[].class, Boolean.TYPE, Properties.class, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

