/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlockStatus;
import software.amazon.awssdk.services.ec2.model.CapacityBlockStatusSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityBlockStatusResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityBlockStatusResponse> {
    private static final SdkField<List<CapacityBlockStatus>> CAPACITY_BLOCK_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityBlockStatuses").getter(DescribeCapacityBlockStatusResponse.getter(DescribeCapacityBlockStatusResponse::capacityBlockStatuses)).setter(DescribeCapacityBlockStatusResponse.setter(Builder::capacityBlockStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockStatusSet").unmarshallLocationName("capacityBlockStatusSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityBlockStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityBlockStatusResponse.getter(DescribeCapacityBlockStatusResponse::nextToken)).setter(DescribeCapacityBlockStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityBlockStatusResponse.memberNameToFieldInitializer();
    private final List<CapacityBlockStatus> capacityBlockStatuses;
    private final String nextToken;

    private DescribeCapacityBlockStatusResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlockStatuses = builder.capacityBlockStatuses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityBlockStatuses() {
        return this.capacityBlockStatuses != null && !(this.capacityBlockStatuses instanceof SdkAutoConstructList);
    }

    public final List<CapacityBlockStatus> capacityBlockStatuses() {
        return this.capacityBlockStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityBlockStatuses() ? this.capacityBlockStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockStatusResponse)) {
            return false;
        }
        DescribeCapacityBlockStatusResponse other = (DescribeCapacityBlockStatusResponse)((Object)obj);
        return this.hasCapacityBlockStatuses() == other.hasCapacityBlockStatuses() && Objects.equals(this.capacityBlockStatuses(), other.capacityBlockStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityBlockStatusResponse").add("CapacityBlockStatuses", this.hasCapacityBlockStatuses() ? this.capacityBlockStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockStatuses": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockStatusSet", CAPACITY_BLOCK_STATUSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockStatusResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlockStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityBlockStatus> capacityBlockStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockStatusResponse model) {
            super(model);
            this.capacityBlockStatuses(model.capacityBlockStatuses);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityBlockStatus.Builder> getCapacityBlockStatuses() {
            List<CapacityBlockStatus.Builder> result = CapacityBlockStatusSetCopier.copyToBuilder(this.capacityBlockStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlockStatuses(Collection<CapacityBlockStatus.BuilderImpl> capacityBlockStatuses) {
            this.capacityBlockStatuses = CapacityBlockStatusSetCopier.copyFromBuilder(capacityBlockStatuses);
        }

        @Override
        public final Builder capacityBlockStatuses(Collection<CapacityBlockStatus> capacityBlockStatuses) {
            this.capacityBlockStatuses = CapacityBlockStatusSetCopier.copy(capacityBlockStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockStatuses(CapacityBlockStatus ... capacityBlockStatuses) {
            this.capacityBlockStatuses(Arrays.asList(capacityBlockStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockStatuses(Consumer<CapacityBlockStatus.Builder> ... capacityBlockStatuses) {
            this.capacityBlockStatuses(Stream.of(capacityBlockStatuses).map(c -> (CapacityBlockStatus)((CapacityBlockStatus.Builder)CapacityBlockStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlockStatusResponse build() {
            return new DescribeCapacityBlockStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityBlockStatusResponse> {
        public Builder capacityBlockStatuses(Collection<CapacityBlockStatus> var1);

        public Builder capacityBlockStatuses(CapacityBlockStatus ... var1);

        public Builder capacityBlockStatuses(Consumer<CapacityBlockStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

