/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre z\u00f3naid\u0151",
               "",
               "Acre ny\u00e1ri id\u0151",
               "",
               "Acre id\u0151",
               "",
            };
        final String[] Apia = new String[] {
               "apiai t\u00e9li id\u0151",
               "",
               "apiai ny\u00e1ri id\u0151",
               "",
               "apiai id\u0151",
               "",
            };
        final String[] Cook = new String[] {
               "cook-szigeteki t\u00e9li id\u0151",
               "",
               "cook-szigeteki f\u00e9l ny\u00e1ri id\u0151",
               "",
               "cook-szigeteki id\u0151",
               "",
            };
        final String[] Cuba = new String[] {
               "kubai t\u00e9li id\u0151",
               "CST",
               "kubai ny\u00e1ri id\u0151",
               "CDT",
               "kubai id\u0151z\u00f3na",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fidzsi t\u00e9li id\u0151",
               "",
               "fidzsi ny\u00e1ri id\u0151",
               "",
               "fidzsi id\u0151",
               "",
            };
        final String[] Gulf = new String[] {
               "\u00f6b\u00f6lbeli t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hovdi t\u00e9li id\u0151",
               "",
               "hovdi ny\u00e1ri id\u0151",
               "",
               "hovdi id\u0151",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u00e1ni t\u00e9li id\u0151",
               "",
               "ir\u00e1ni ny\u00e1ri id\u0151",
               "",
               "ir\u00e1ni id\u0151",
               "",
            };
        final String[] Niue = new String[] {
               "niuei id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omszki t\u00e9li id\u0151",
               "",
               "omszki ny\u00e1ri id\u0151",
               "",
               "omszki id\u0151",
               "",
            };
        final String[] Peru = new String[] {
               "perui t\u00e9li id\u0151",
               "",
               "perui ny\u00e1ri id\u0151",
               "",
               "perui id\u0151",
               "",
            };
        final String[] Truk = new String[] {
               "truki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "wake-szigeti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilei t\u00e9li id\u0151",
               "",
               "chilei ny\u00e1ri id\u0151",
               "",
               "chilei id\u0151z\u00f3na",
               "",
            };
        final String[] China = new String[] {
               "k\u00ednai t\u00e9li id\u0151",
               "CST",
               "k\u00ednai ny\u00e1ri id\u0151",
               "CDT",
               "k\u00ednai id\u0151",
               "CT",
            };
        final String[] Cocos = new String[] {
               "k\u00f3kusz-szigeteki t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "davisi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indiai t\u00e9li id\u0151",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "jap\u00e1n t\u00e9li id\u0151",
               "JST",
               "jap\u00e1n ny\u00e1ri id\u0151",
               "JDT",
               "jap\u00e1n id\u0151",
               "JT",
            };
        final String[] Korea = new String[] {
               "koreai t\u00e9li id\u0151",
               "KST",
               "koreai ny\u00e1ri id\u0151",
               "KST",
               "koreai id\u0151",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naurui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palaui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "szamoai t\u00e9li id\u0151",
               "SST",
               "szamoai ny\u00e1ri id\u0151",
               "SST",
               "szamoai id\u0151",
               "SST",
            };
        final String[] Syowa = new String[] {
               "syowai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tongai t\u00e9li id\u0151",
               "",
               "tongai ny\u00e1ri id\u0151",
               "",
               "tongai id\u0151",
               "",
            };
        final String[] Yukon = new String[] {
               "yukoni id\u0151",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alaszkai z\u00f3naid\u0151",
               "AKST",
               "alaszkai ny\u00e1ri id\u0151",
               "AKDT",
               "alaszkai id\u0151",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amaz\u00f3niai t\u00e9li id\u0151",
               "",
               "amaz\u00f3niai ny\u00e1ri id\u0151",
               "",
               "amaz\u00f3niai id\u0151",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anad\u00edri z\u00f3naid\u0151",
               "",
               "Anad\u00edri ny\u00e1ri id\u0151",
               "",
               "Anadiri id\u0151",
               "",
            };
        final String[] Azores = new String[] {
               "azori t\u00e9li id\u0151",
               "",
               "azori ny\u00e1ri id\u0151",
               "",
               "azori id\u0151z\u00f3na",
               "",
            };
        final String[] Bhutan = new String[] {
               "but\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "h\u00fasv\u00e9t-szigeti t\u00e9li id\u0151",
               "",
               "h\u00fasv\u00e9t-szigeti ny\u00e1ri id\u0151",
               "",
               "h\u00fasv\u00e9t-szigeti id\u0151z\u00f3na",
               "",
            };
        final String[] Guyana = new String[] {
               "guyanai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraeli t\u00e9li id\u0151",
               "IST",
               "izraeli ny\u00e1ri id\u0151",
               "IDT",
               "izraeli id\u0151",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kosraei id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "mawsoni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moszkvai t\u00e9li id\u0151",
               "MSK",
               "moszkvai ny\u00e1ri id\u0151",
               "MSK",
               "moszkvai id\u0151",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponape-szigeti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Szamarai z\u00f3naid\u0151",
               "",
               "Szamarai ny\u00e1ri id\u0151",
               "",
               "Szamarai id\u0151",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahiti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "taipei t\u00e9li id\u0151",
               "CST",
               "taipei ny\u00e1ri id\u0151",
               "CDT",
               "taipei id\u0151",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "vosztoki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis \u00e9s Futuna-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arab t\u00e9li id\u0151",
               "",
               "arab ny\u00e1ri id\u0151",
               "",
               "arab id\u0151",
               "",
            };
        final String[] Armenia = new String[] {
               "\u00f6rm\u00e9nyorsz\u00e1gi t\u00e9li id\u0151",
               "",
               "\u00f6rm\u00e9nyorsz\u00e1gi ny\u00e1ri id\u0151",
               "",
               "\u00f6rm\u00e9nyorsz\u00e1gi id\u0151",
               "",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edviai t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathami t\u00e9li id\u0151",
               "",
               "chathami ny\u00e1ri id\u0151",
               "",
               "chathami id\u0151",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordin\u00e1lt vil\u00e1gid\u0151",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ecuadori t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambieri id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gr\u00faziai t\u00e9li id\u0151",
               "",
               "gr\u00faziai ny\u00e1ri id\u0151",
               "",
               "gr\u00faziai id\u0151",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutszki t\u00e9li id\u0151",
               "",
               "irkutszki ny\u00e1ri id\u0151",
               "",
               "irkutszki id\u0151",
               "",
            };
        final String[] Magadan = new String[] {
               "magadani t\u00e9li id\u0151",
               "",
               "magad\u00e1ni ny\u00e1ri id\u0151",
               "",
               "magad\u00e1ni id\u0151",
               "",
            };
        final String[] Myanmar = new String[] {
               "mianmari id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolk-szigeteki t\u00e9li id\u0151",
               "",
               "norfolk-szigeteki ny\u00e1ri id\u0151",
               "",
               "norfolk-szigeteki id\u0151",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-i t\u00e9li id\u0151",
               "",
               "Fernando de Noronha-i ny\u00e1ri id\u0151",
               "",
               "Fernando de Noronha-i id\u0151",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unioni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "rotherai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "salamon-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelaui id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayi t\u00e9li id\u0151",
               "",
               "uruguayi ny\u00e1ri id\u0151",
               "",
               "uruguayi id\u0151",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatui t\u00e9li id\u0151",
               "",
               "vanuatui ny\u00e1ri id\u0151",
               "",
               "vanuatui id\u0151",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutszki t\u00e9li id\u0151",
               "",
               "jakutszki ny\u00e1ri id\u0151",
               "",
               "jakutszki id\u0151",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlanti-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "AST",
               "atlanti-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "AST",
               "atlanti-\u00f3ce\u00e1ni id\u0151",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edliai t\u00e9li id\u0151",
               "",
               "braz\u00edliai ny\u00e1ri id\u0151",
               "",
               "braz\u00edliai id\u0151",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorr\u00f3i t\u00e9li id\u0151",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbiai t\u00e9li id\u0151",
               "",
               "kolumbiai ny\u00e1ri id\u0151",
               "",
               "kolumbiai id\u0151",
               "",
            };
        final String[] Falkland = new String[] {
               "falkland-szigeteki t\u00e9li id\u0151",
               "",
               "falkland-szigeteki ny\u00e1ri id\u0151",
               "",
               "falkland-szigeteki id\u0151",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajziai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "mald\u00edv-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ul\u00e1nb\u00e1tori t\u00e9li id\u0151",
               "",
               "ul\u00e1nb\u00e1tori ny\u00e1ri id\u0151",
               "",
               "ul\u00e1nb\u00e1tori id\u0151",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakiszt\u00e1ni t\u00e9li id\u0151",
               "PKT",
               "pakiszt\u00e1ni ny\u00e1ri id\u0151",
               "PKST",
               "pakiszt\u00e1ni id\u0151",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayi t\u00e9li id\u0151",
               "",
               "paraguayi ny\u00e1ri id\u0151",
               "",
               "paraguayi id\u0151",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pitcairn-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "szahalini t\u00e9li id\u0151",
               "",
               "szahalini ny\u00e1ri id\u0151",
               "",
               "szahalini id\u0151",
               "",
            };
        final String[] Suriname = new String[] {
               "szurin\u00e1mi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednai t\u00e9li id\u0151",
               "",
               "argent\u00ednai ny\u00e1ri id\u0151",
               "",
               "argent\u00ednai id\u0151",
               "",
            };
        final String[] Christmas = new String[] {
               "kar\u00e1csony-szigeti id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "gal\u00e1pagosi t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongi t\u00e9li id\u0151",
               "HKT",
               "hongkongi ny\u00e1ri id\u0151",
               "HKST",
               "hongkongi id\u0151z\u00f3na",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indok\u00ednai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovszk-kamcsatkai z\u00f3naid\u0151",
               "",
               "Petropavlovszk-kamcsatkai ny\u00e1ri id\u0151",
               "",
               "Petropavlovszk-kamcsatkai id\u0151",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgiziszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-szigeti t\u00e9li id\u0151",
               "",
               "Lord Howe-szigeti ny\u00e1ri id\u0151",
               "",
               "Lord Howe-szigeti id\u0151",
               "",
            };
        final String[] Marquesas = new String[] {
               "marquises-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritiusi t\u00e9li id\u0151",
               "",
               "mauritiusi ny\u00e1ri id\u0151",
               "",
               "mauritiusi id\u0151z\u00f3na",
               "",
            };
        final String[] Singapore = new String[] {
               "szingap\u00fari t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "volgogr\u00e1di t\u00e9li id\u0151",
               "MSK",
               "volgogr\u00e1di ny\u00e1ri id\u0151",
               "MSK",
               "volgogr\u00e1di id\u0151",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzs\u00e1ni t\u00e9li id\u0151",
               "",
               "azerbajdzs\u00e1ni ny\u00e1ri id\u0151",
               "",
               "azerbajdzs\u00e1ni id\u0151",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladesi t\u00e9li id\u0151",
               "",
               "bangladesi ny\u00e1ri id\u0151",
               "",
               "bangladesi id\u0151",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "z\u00f6ld-foki-szigeteki t\u00e9li id\u0151",
               "",
               "z\u00f6ld-foki-szigeteki ny\u00e1ri id\u0151",
               "",
               "z\u00f6ld-foki-szigeteki id\u0151z\u00f3na",
               "",
            };
        final String[] East_Timor = new String[] {
               "kelet-timori t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazahszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelle-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "t\u00e1dzsikiszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u00fczbegiszt\u00e1ni t\u00e9li id\u0151",
               "",
               "\u00fczbegiszt\u00e1ni ny\u00e1ri id\u0151",
               "",
               "\u00fczbegiszt\u00e1ni id\u0151",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afganiszt\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasznojarszki t\u00e9li id\u0151",
               "",
               "krasznojarszki ny\u00e1ri id\u0151",
               "",
               "krasznojarszki id\u0151",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u00faj-z\u00e9landi t\u00e9li id\u0151",
               "NZST",
               "\u00faj-z\u00e9landi ny\u00e1ri id\u0151",
               "NZDT",
               "\u00faj-z\u00e9landi id\u0151",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "novoszibirszki t\u00e9li id\u0151",
               "",
               "novoszibirszki ny\u00e1ri id\u0151",
               "",
               "novoszibirszki id\u0151",
               "",
            };
        final String[] Philippines = new String[] {
               "f\u00fcl\u00f6p-szigeteki t\u00e9li id\u0151",
               "PST",
               "f\u00fcl\u00f6p-szigeteki ny\u00e1ri id\u0151",
               "PDT",
               "f\u00fcl\u00f6p-szigeteki id\u0151",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vlagyivosztoki t\u00e9li id\u0151",
               "",
               "vlagyivosztoki ny\u00e1ri id\u0151",
               "",
               "vlagyivosztoki id\u0151",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indiai-\u00f3ce\u00e1ni id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "sor-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "\u00faj-fundlandi z\u00f3naid\u0151",
               "NST",
               "\u00faj-fundlandi ny\u00e1ri id\u0151",
               "NDT",
               "\u00faj-fundlandi id\u0151",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "t\u00fcrkmeniszt\u00e1ni t\u00e9li id\u0151",
               "",
               "t\u00fcrkmeniszt\u00e1ni ny\u00e1ri id\u0151",
               "",
               "t\u00fcrkmeniszt\u00e1ni id\u0151",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francia-guyanai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "\u00faj-kaled\u00f3niai t\u00e9li id\u0151",
               "",
               "\u00faj-kaled\u00f3niai ny\u00e1ri id\u0151",
               "",
               "\u00faj-kaled\u00f3niai id\u0151",
               "",
            };
        final String[] South_Georgia = new String[] {
               "d\u00e9li-georgiai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekatyerinburgi t\u00e9li id\u0151",
               "",
               "jekatyerinburgi ny\u00e1ri id\u0151",
               "",
               "jekatyerinburgi id\u0151",
               "",
            };
        final String[] Africa_Central = new String[] {
               "k\u00f6z\u00e9p-afrikai t\u00e9li id\u0151",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "kelet-afrikai t\u00e9li id\u0151",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "nyugat-afrikai t\u00e9li id\u0151",
               "WAT",
               "nyugat-afrikai ny\u00e1ri id\u0151",
               "WAT",
               "nyugat-afrikai id\u0151z\u00f3na",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "dumont-d\u2019Urville-i id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "k\u00f6z\u00e9p-eur\u00f3pai t\u00e9li id\u0151",
               "CET",
               "k\u00f6z\u00e9p-eur\u00f3pai ny\u00e1ri id\u0151",
               "CEST",
               "k\u00f6z\u00e9p-eur\u00f3pai id\u0151z\u00f3na",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "kelet-eur\u00f3pai t\u00e9li id\u0151",
               "EET",
               "kelet-eur\u00f3pai ny\u00e1ri id\u0151",
               "EEST",
               "kelet-eur\u00f3pai id\u0151z\u00f3na",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "nyugat-eur\u00f3pai t\u00e9li id\u0151",
               "WET",
               "nyugat-eur\u00f3pai ny\u00e1ri id\u0151",
               "WEST",
               "nyugat-eur\u00f3pai id\u0151z\u00f3na",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "MST",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "MDT",
               "mexik\u00f3i csendes-\u00f3ce\u00e1ni id\u0151",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "d\u00e9l-afrikai t\u00e9li id\u0151",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli z\u00f3naid\u0151",
               "CST",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli ny\u00e1ri id\u0151",
               "CDT",
               "k\u00f6z\u00e9ps\u0151 \u00e1llamokbeli id\u0151",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "keleti \u00e1llamokbeli z\u00f3naid\u0151",
               "EST",
               "keleti \u00e1llamokbeli ny\u00e1ri id\u0151",
               "EST",
               "keleti \u00e1llamokbeli id\u0151",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "PST",
               "csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "PDT",
               "csendes-\u00f3ce\u00e1ni id\u0151",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "francia d\u00e9li \u00e9s antarktiszi id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "gilbert-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaii-aleuti t\u00e9li id\u0151",
               "HST",
               "hawaii-aleuti ny\u00e1ri id\u0151",
               "HST",
               "hawaii-aleuti id\u0151z\u00f3na",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "phoenix-szigeteki t\u00e9li id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre \u00e9s Miquelon-i z\u00f3naid\u0151",
               "",
               "Saint-Pierre \u00e9s Miquelon-i ny\u00e1ri id\u0151",
               "",
               "Saint-Pierre \u00e9s Miquelon-i id\u0151",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hegyvid\u00e9ki z\u00f3naid\u0151",
               "MST",
               "hegyvid\u00e9ki ny\u00e1ri id\u0151",
               "MST",
               "hegyvid\u00e9ki id\u0151",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "marshall-szigeteki id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "p\u00e1pua \u00faj-guineai id\u0151",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "k\u00f6z\u00e9p-ausztr\u00e1liai t\u00e9li id\u0151",
               "ACST",
               "k\u00f6z\u00e9p-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "ACDT",
               "k\u00f6z\u00e9p-ausztr\u00e1liai id\u0151",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "kelet-ausztr\u00e1liai t\u00e9li id\u0151",
               "AEST",
               "kelet-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "AEDT",
               "kelet-ausztr\u00e1liai id\u0151",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "AWST",
               "nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "AWDT",
               "nyugat-ausztr\u00e1liai id\u0151",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "k\u00f6z\u00e9p-indon\u00e9ziai id\u0151",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "kelet-indon\u00e9ziai id\u0151",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "nyugat-indon\u00e9ziai t\u00e9li id\u0151",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai t\u00e9li id\u0151",
               "",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai ny\u00e1ri id\u0151",
               "",
               "k\u00f6z\u00e9p-nyugat-ausztr\u00e1liai id\u0151",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "\u00edr ny\u00e1ri id\u0151",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordin\u00e1lt vil\u00e1gid\u0151",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "\u00edr ny\u00e1ri id\u0151",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "greenwichi k\u00f6z\u00e9pid\u0151, t\u00e9li id\u0151",
                    "GMT",
                    "brit ny\u00e1ri id\u0151",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "\u00c1den" },
            { "timezone.excity.Asia/Gaza", "G\u00e1za" },
            { "timezone.excity.Asia/Omsk", "Omszk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Csita" },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Macau", "Maka\u00f3" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Sz\u00f6ul" },
            { "timezone.excity.Asia/Tokyo", "Toki\u00f3" },
            { "timezone.excity.Asia/Tomsk", "Tomszk" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Akt\u00f6be" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "timezone.excity.Asia/Kuwait", "Kuvait" },
            { "timezone.excity.Asia/Muscat", "Maszkat" },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "timezone.excity.Asia/Saigon", "Ho Si Minh-v\u00e1ros" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmcsi" },
            { "timezone.excity.Etc/Unknown", "Ismeretlen v\u00e1ros" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Rome", "R\u00f3ma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kair\u00f3" },
            { "timezone.excity.Africa/Tunis", "Tunisz" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Biskek" },
            { "timezone.excity.Asia/Irkutsk", "Irkutszk" },
            { "timezone.excity.Asia/Karachi", "Karacsi" },
            { "timezone.excity.Asia/Kuching", "Kucseng" },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Asia/Tbilisi", "Tbiliszi" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutszk" },
            { "timezone.excity.Asia/Yerevan", "Jerev\u00e1n" },
            { "timezone.excity.Europe/Malta", "M\u00e1lta" },
            { "timezone.excity.Europe/Minsk", "Minszk" },
            { "timezone.excity.Europe/Paris", "P\u00e1rizs" },
            { "timezone.excity.Europe/Sofia", "Sz\u00f3fia" },
            { "timezone.excity.Indian/Cocos", "K\u00f3kusz-sziget" },
            { "timezone.excity.Pacific/Fiji", "Fidzsi" },
            { "timezone.excity.Pacific/Truk", "Truk" },
            { "timezone.excity.Pacific/Wake", "Wake-sziget" },
            { "timezone.excity.Africa/Asmera", "Aszmara" },
            { "timezone.excity.Africa/Malabo", "Malab\u00f3" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "Asgabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaszkusz" },
            { "timezone.excity.Asia/Dushanbe", "Dusanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kosztanaj" },
            { "timezone.excity.Asia/Sakhalin", "Szahalin" },
            { "timezone.excity.Asia/Shanghai", "Sanghaj" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.Asia/Ust-Nera", "Uszty-Nyera" },
            { "timezone.excity.Europe/Athens", "Ath\u00e9n" },
            { "timezone.excity.Europe/Lisbon", "Lisszabon" },
            { "timezone.excity.Europe/Moscow", "Moszkva" },
            { "timezone.excity.Europe/Prague", "Pr\u00e1ga" },
            { "timezone.excity.Europe/Samara", "Szamara" },
            { "timezone.excity.Europe/Skopje", "Szkopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "B\u00e9cs" },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1gr\u00e1b" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komor\u00f3" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alg\u00edr" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Kajm\u00e1n-szigetek" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzs\u00e1lem" },
            { "timezone.excity.Asia/Kamchatka", "Kamcsatka" },
            { "timezone.excity.Asia/Pyongyang", "Phenjan" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Szamarkand" },
            { "timezone.excity.Asia/Singapore", "Szingap\u00far" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "timezone.excity.Europe/Saratov", "Szaratov" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Pacific/Easter", "H\u00fasv\u00e9t-szigetek" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae-szigetek" },
            { "timezone.excity.Pacific/Majuro", "Majuro-z\u00e1tony" },
            { "timezone.excity.Pacific/Midway", "Midway-szigetek" },
            { "timezone.excity.Pacific/Ponape", "Ponape-szigetek" },
            { "timezone.excity.Africa/Djibouti", "Dzsibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aj\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Kart\u00fam" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.Atlantic/Azores", "Azori-szigetek" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1ri-szigetek" },
            { "timezone.excity.Atlantic/Faeroe", "Fer\u00f6er" },
            { "timezone.excity.Europe/Belgrade", "Belgr\u00e1d" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcsszel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Istanbul", "Isztanbul" },
            { "timezone.excity.Europe/Sarajevo", "Szarajev\u00f3" },
            { "timezone.excity.Indian/Maldives", "Mald\u00edv-szigetek" },
            { "timezone.excity.Pacific/Chatham", "Chatham-szigetek" },
            { "timezone.excity.Pacific/Gambier", "Gambier-szigetek" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasznojarszk" },
            { "timezone.excity.Asia/Novosibirsk", "Novoszibirszk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tor" },
            { "timezone.excity.Asia/Vladivostok", "Vlagyivosztok" },
            { "timezone.excity.Europe/Amsterdam", "Amszterdam" },
            { "timezone.excity.Europe/Astrakhan", "Asztrah\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u00e1r" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovszk" },
            { "timezone.excity.Europe/Volgograd", "Volgogr\u00e1d" },
            { "timezone.excity.Indian/Christmas", "Kar\u00e1csony-sziget" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn-szigetek" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Antarctica/Vostok", "Vosztok" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznyeck" },
            { "timezone.excity.Europe/Bratislava", "Pozsony" },
            { "timezone.excity.Europe/Copenhagen", "Koppenh\u00e1ga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Simferopol", "Szimferopol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos-szigetek" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein-z\u00e1tony" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-szigetek" },
            { "timezone.excity.Africa/Addis_Ababa", "Addisz-Abeba" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "timezone.excity.Asia/Srednekolymsk", "Szrednekolimszk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekatyerinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Szent Ilona" },
            { "timezone.excity.Europe/Isle_of_Man", "Man-sziget" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinyingr\u00e1d" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati-sziget" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Mexik\u00f3v\u00e1ros" },
            { "timezone.excity.Atlantic/Cape_Verde", "Z\u00f6ld-foki szigetek" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es-Salaam" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "D\u00e9li-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, \u00c9szak-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, \u00c9szak-Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, \u00c9szak-Dakota" },
        };
        return data;
    }
}
