/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PublicKeyCredentialParameters {
    private final PublicKeyCredentialType type;
    private final COSEAlgorithmIdentifier alg;

    @JsonCreator
    public PublicKeyCredentialParameters(@JsonProperty(value="type") @NotNull PublicKeyCredentialType type, @JsonProperty(value="alg") @NotNull COSEAlgorithmIdentifier alg) {
        AssertUtil.notNull(type, "type must not be null");
        AssertUtil.notNull(alg, "alg must not be null");
        this.type = type;
        this.alg = alg;
    }

    @NotNull
    public PublicKeyCredentialType getType() {
        return this.type;
    }

    @NotNull
    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialParameters that = (PublicKeyCredentialParameters)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.alg, that.alg);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.alg);
    }

    public String toString() {
        return "PublicKeyCredentialParameters(type=" + String.valueOf(this.type) + ", alg=" + String.valueOf(this.alg) + ")";
    }
}

