/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.Interruptible;

public abstract class AbstractSelector
extends Selector {
    private AtomicBoolean selectorOpen = new AtomicBoolean(true);
    private final SelectorProvider provider;
    private final Set<SelectionKey> cancelledKeys = new HashSet<SelectionKey>();
    private Interruptible interruptor = null;

    protected AbstractSelector(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(SelectionKey selectionKey) {
        Set<SelectionKey> set = this.cancelledKeys;
        synchronized (set) {
            this.cancelledKeys.add(selectionKey);
        }
    }

    @Override
    public final void close() throws IOException {
        boolean bl = this.selectorOpen.getAndSet(false);
        if (!bl) {
            return;
        }
        this.implCloseSelector();
    }

    protected abstract void implCloseSelector() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.selectorOpen.get();
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    protected final Set<SelectionKey> cancelledKeys() {
        return this.cancelledKeys;
    }

    protected abstract SelectionKey register(AbstractSelectableChannel var1, int var2, Object var3);

    protected final void deregister(AbstractSelectionKey abstractSelectionKey) {
        ((AbstractSelectableChannel)abstractSelectionKey.channel()).removeKey(abstractSelectionKey);
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                @Override
                public void interrupt(Thread thread) {
                    AbstractSelector.this.wakeup();
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            this.interruptor.interrupt(thread);
        }
    }

    protected final void end() {
        AbstractInterruptibleChannel.blockedOn(null);
    }
}

