/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/JpsKotlinBuildSystemDependencyManager;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "suggestNameForLibrary", "", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "projectLibraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "createNewLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "libraryDescriptor", "findExistingLibrary", "addDependency", "", "getBuildScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectSyncInProgress", "isProjectSyncPending", "startProjectSync", "intellij.kotlin.projectConfiguration"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJpsKotlinBuildSystemDependencyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsKotlinBuildSystemDependencyManager.kt\norg/jetbrains/kotlin/idea/configuration/JpsKotlinBuildSystemDependencyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n1869#2,2:119\n295#2,2:132\n4225#3,11:121\n*S KotlinDebug\n*F\n+ 1 JpsKotlinBuildSystemDependencyManager.kt\norg/jetbrains/kotlin/idea/configuration/JpsKotlinBuildSystemDependencyManager\n*L\n68#1:119,2\n79#1:132,2\n79#1:121,11\n*E\n"})
public final class JpsKotlinBuildSystemDependencyManager
implements KotlinBuildSystemDependencyManager {
    @Override
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return !ProjectStructureUtils.isGradleModule(module) && !ProjectStructureUtils.isMavenModule(module) && ExternalSystemApiUtil.getExternalProjectPath((Module)module) == null;
    }

    private final String suggestNameForLibrary(ExternalLibraryDescriptor $this$suggestNameForLibrary, LibraryTable projectLibraryTable) {
        if (projectLibraryTable.getLibraryByName($this$suggestNameForLibrary.getPresentableName()) == null) {
            return $this$suggestNameForLibrary.getPresentableName();
        }
        for (int i2 = 1; i2 < 1001; ++i2) {
            String nameToCheck = $this$suggestNameForLibrary.getPresentableName() + i2;
            if (projectLibraryTable.getLibraryByName(nameToCheck) != null) continue;
            return nameToCheck;
        }
        return null;
    }

    private final Library createNewLibrary(Project $this$createNewLibrary, ExternalLibraryDescriptor libraryDescriptor) {
        LibraryEx.ModifiableModelEx modifiableModelEx;
        String string = libraryDescriptor.getPreferredVersion();
        if (string == null && (string = libraryDescriptor.getMaxVersion()) == null && (string = libraryDescriptor.getMinVersion()) == null) {
            return null;
        }
        String version = string;
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable($this$createNewLibrary);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable projectLibraryTable = libraryTable;
        String string2 = this.suggestNameForLibrary(libraryDescriptor, projectLibraryTable);
        if (string2 == null) {
            return null;
        }
        String nameToUse = string2;
        Library library = projectLibraryTable.createLibrary(nameToUse);
        LibraryEx libraryEx = library instanceof LibraryEx ? (LibraryEx)library : null;
        if (libraryEx == null) {
            return null;
        }
        LibraryEx library2 = libraryEx;
        LibraryEx.ModifiableModelEx $this$createNewLibrary_u24lambda_u240 = modifiableModelEx = library2.getModifiableModel();
        boolean bl = false;
        $this$createNewLibrary_u24lambda_u240.setKind(RepositoryLibraryType.REPOSITORY_LIBRARY_KIND);
        RepositoryLibraryProperties repositoryProperties = new RepositoryLibraryProperties(libraryDescriptor.getLibraryGroupId(), libraryDescriptor.getLibraryArtifactId(), version, true, CollectionsKt.emptyList());
        $this$createNewLibrary_u24lambda_u240.setProperties((LibraryProperties)repositoryProperties);
        Collection dependencies = JarRepositoryManager.loadDependenciesModal((Project)$this$createNewLibrary, (RepositoryLibraryProperties)repositoryProperties, (boolean)true, (boolean)true, null, null);
        Intrinsics.checkNotNull((Object)dependencies);
        Iterable $this$forEach$iv = dependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrderRoot it = (OrderRoot)element$iv;
            boolean bl2 = false;
            $this$createNewLibrary_u24lambda_u240.addRoot(it.getFile(), it.getType());
        }
        modifiableModelEx.commit();
        return (Library)library2;
    }

    /*
     * WARNING - void declaration
     */
    private final Library findExistingLibrary(Project $this$findExistingLibrary, ExternalLibraryDescriptor libraryDescriptor) {
        Object v4;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            String string = libraryDescriptor.getPreferredVersion();
            if (string == null) {
                return null;
            }
            String version = string;
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable($this$findExistingLibrary);
            Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
            LibraryTable projectLibraryTable = libraryTable;
            Library[] libraryArray = projectLibraryTable.getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
            Object $this$filterIsInstance$iv = libraryArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LibraryEx)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RepositoryLibraryProperties properties;
                LibraryEx library = (LibraryEx)element$iv;
                boolean bl = false;
                LibraryProperties libraryProperties = library.getProperties();
                RepositoryLibraryProperties repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
                if (!(repositoryLibraryProperties == null ? false : Intrinsics.areEqual((Object)(properties = repositoryLibraryProperties).getArtifactId(), (Object)libraryDescriptor.getLibraryArtifactId()) && Intrinsics.areEqual((Object)properties.getGroupId(), (Object)libraryDescriptor.getLibraryGroupId()) && Intrinsics.areEqual((Object)properties.getVersion(), (Object)version))) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        return v4;
    }

    @Override
    public void addDependency(@NotNull Module module, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        DependencyScope dependencyScope = libraryDescriptor.getPreferredScope();
        if (dependencyScope == null) {
            dependencyScope = DependencyScope.COMPILE;
        }
        DependencyScope scope = dependencyScope;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Library library = this.findExistingLibrary(project, libraryDescriptor);
        if (library == null) {
            Project project2 = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            library = this.createNewLibrary(project2, libraryDescriptor);
            if (library == null) {
                return;
            }
        }
        Library library2 = library;
        ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
        ModifiableRootModel modifiableModule = modifiableRootModel;
        modifiableModule.addLibraryEntries(CollectionsKt.listOf((Object)library2), scope, false);
        modifiableModule.commit();
    }

    @Override
    @Nullable
    public VirtualFile getBuildScriptFile(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return null;
    }

    @Override
    public boolean isProjectSyncInProgress() {
        return false;
    }

    @Override
    public boolean isProjectSyncPending() {
        return false;
    }

    @Override
    public void startProjectSync() {
    }
}

