/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaPlatformInterface;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.KaEntityBasedModuleCreationData;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.KaModuleWithDebugData;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.library.KaEntityBasedLibraryModuleBase;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.modules.librarySource.KaLibrarySdkSourceModuleImpl;
import org.jetbrains.kotlin.idea.base.fir.projectStructure.provider.InternalKaModuleConstructor;
import org.jetbrains.kotlin.idea.base.util.caching.WorkspaceEntityChangeListenerKt;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B!\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u00105\u001a\u00020)2\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\b\u00108\u001a\u000209H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R'\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178VX\u0097\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001d\u0010#\u001a\u0004\u0018\u00010$8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001e\u001a\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020)8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u001a\u001a\u0004\b(\u0010+R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001c\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u000202018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaLibrarySdkModuleImpl;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/library/KaEntityBasedLibraryModuleBase;", "Lcom/intellij/platform/workspace/jps/entities/SdkEntity;", "Lcom/intellij/platform/workspace/jps/entities/SdkId;", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/KaModuleWithDebugData;", "project", "Lcom/intellij/openapi/project/Project;", "entityId", "creationData", "Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/KaEntityBasedModuleCreationData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/jps/entities/SdkId;Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/KaEntityBasedModuleCreationData;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getEntityId", "()Lcom/intellij/platform/workspace/jps/entities/SdkId;", "getCreationData", "()Lorg/jetbrains/kotlin/idea/base/fir/projectStructure/modules/KaEntityBasedModuleCreationData;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "binaryVirtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBinaryVirtualFiles$annotations", "()V", "getBinaryVirtualFiles", "()Ljava/util/Collection;", "binaryVirtualFiles$delegate", "Lkotlin/Lazy;", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "librarySources", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "librarySources$delegate", "isSdk", "", "isSdk$annotations", "()Z", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "entityInterface", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getEntityInterface", "()Ljava/lang/Class;", "equals", "other", "", "hashCode", "", "intellij.kotlin.projectStructure"})
public final class KaLibrarySdkModuleImpl
extends KaEntityBasedLibraryModuleBase<SdkEntity, SdkId>
implements KaModuleWithDebugData {
    @NotNull
    private final Project project;
    @NotNull
    private final SdkId entityId;
    @NotNull
    private final KaEntityBasedModuleCreationData creationData;
    @NotNull
    private final Lazy binaryVirtualFiles$delegate;
    @NotNull
    private final Lazy librarySources$delegate;

    @InternalKaModuleConstructor
    public KaLibrarySdkModuleImpl(@NotNull Project project, @NotNull SdkId entityId, @NotNull KaEntityBasedModuleCreationData creationData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)creationData, (String)"creationData");
        this.project = project;
        this.entityId = entityId;
        this.creationData = creationData;
        this.binaryVirtualFiles$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibrarySdkModuleImpl.binaryVirtualFiles_delegate$lambda$0(this));
        this.librarySources$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaLibrarySdkModuleImpl.librarySources_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public SdkId getEntityId() {
        return this.entityId;
    }

    @Override
    @NotNull
    public KaEntityBasedModuleCreationData getCreationData() {
        return this.creationData;
    }

    @NotNull
    public final Sdk getSdk() {
        Sdk sdk2 = WorkspaceEntityChangeListenerKt.findSdkBridge((SdkEntity)this.getEntity(), (EntityStorage)this.getCurrentSnapshot());
        if (sdk2 == null) {
            throw new IllegalStateException(("Could not find SDK " + this.getEntityId()).toString());
        }
        return sdk2;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getBinaryVirtualFiles() {
        Lazy lazy = this.binaryVirtualFiles$delegate;
        return (Collection)lazy.getValue();
    }

    @KaExperimentalApi
    public static /* synthetic */ void getBinaryVirtualFiles$annotations() {
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return ((SdkEntity)this.getEntity()).getName();
    }

    @Override
    @Nullable
    public KaLibrarySourceModule getLibrarySources() {
        Lazy lazy = this.librarySources$delegate;
        return (KaLibrarySourceModule)lazy.getValue();
    }

    @Override
    public boolean isSdk() {
        return true;
    }

    @KaPlatformInterface
    public static /* synthetic */ void isSdk$annotations() {
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return this.getSdk().getSdkType() instanceof KotlinSdkType ? CommonPlatforms.INSTANCE.getDefaultCommonPlatform() : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public Class<? extends WorkspaceEntity> getEntityInterface() {
        return SdkEntity.class;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof KaLibrarySdkModuleImpl && Intrinsics.areEqual((Object)((KaLibrarySdkModuleImpl)other).getEntityId(), (Object)this.getEntityId());
    }

    @Override
    public int hashCode() {
        return this.getEntityId().hashCode();
    }

    private static final List binaryVirtualFiles_delegate$lambda$0(KaLibrarySdkModuleImpl this$0) {
        VirtualFile[] virtualFileArray = this$0.getSdk().getRootProvider().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        return ArraysKt.toList((Object[])virtualFileArray);
    }

    private static final KaLibrarySdkSourceModuleImpl librarySources_delegate$lambda$0(KaLibrarySdkModuleImpl this$0) {
        return new KaLibrarySdkSourceModuleImpl(this$0);
    }
}

