/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorUtils;

public class TracingStrategyImpl
extends AbstractTracingStrategy {
    private final KtReferenceExpression reference;

    private TracingStrategyImpl(@NotNull KtReferenceExpression reference2, @NotNull Call call2) {
        if (reference2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(1);
        }
        super(reference2, call2);
        this.reference = reference2;
    }

    @NotNull
    public static TracingStrategy create(@NotNull KtReferenceExpression reference2, @NotNull Call call2) {
        if (reference2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(2);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(3);
        }
        return new TracingStrategyImpl(reference2, call2);
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(4);
        }
        if (call2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(5);
        }
        trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        DeclarationDescriptor storedReference;
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(6);
        }
        if (resolvedCall2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(7);
        }
        Object descriptor = resolvedCall2.getCandidateDescriptor();
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            descriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
        }
        if (descriptor instanceof FakeCallableDescriptorForObject) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject = (FakeCallableDescriptorForObject)descriptor;
            descriptor = fakeCallableDescriptorForObject.getReferencedDescriptor();
            if (fakeCallableDescriptorForObject.getClassDescriptor().getCompanionObjectDescriptor() != null) {
                trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, this.reference, fakeCallableDescriptorForObject.getClassDescriptor());
            }
        }
        if ((storedReference = trace.get(BindingContext.REFERENCE_TARGET, this.reference)) == null || !ErrorUtils.isError(descriptor)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.reference, descriptor);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(8);
        }
        if (resolvedCall2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(9);
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(10);
        }
        trace.report(Errors.UNRESOLVED_REFERENCE.on(this.reference, this.reference));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        VariableDescriptor variableDescriptor;
        if (trace == null) {
            TracingStrategyImpl.$$$reportNull$$$0(11);
        }
        if (candidates == null) {
            TracingStrategyImpl.$$$reportNull$$$0(12);
        }
        if ((variableDescriptor = TracingStrategyImpl.isFunctionExpectedError(candidates)) != null) {
            trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, variableDescriptor.getType()));
        } else {
            trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates));
        }
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor isFunctionExpectedError(@NotNull Collection<? extends ResolvedCall<D>> candidates) {
        if (candidates == null) {
            TracingStrategyImpl.$$$reportNull$$$0(13);
        }
        List<VariableDescriptor> variables2 = CollectionsKt.map(candidates, TracingStrategyImpl::variableIfFunctionExpectedError);
        List<VariableDescriptor> distinctVariables = CollectionsKt.distinct(variables2);
        return CollectionsKt.singleOrNull(distinctVariables);
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor variableIfFunctionExpectedError(@NotNull ResolvedCall<D> candidate2) {
        if (candidate2 == null) {
            TracingStrategyImpl.$$$reportNull$$$0(14);
        }
        if (!(candidate2 instanceof VariableAsFunctionResolvedCall)) {
            return null;
        }
        ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)candidate2)).getVariableCall();
        ResolvedCall<FunctionDescriptor> functionCall = ((VariableAsFunctionResolvedCall)((Object)candidate2)).getFunctionCall();
        KotlinType type = variableCall.getCandidateDescriptor().getType();
        boolean nonFunctionalVar = variableCall.getStatus().isSuccess() && !FunctionTypesKt.isFunctionType(type);
        Call functionPsiCall = functionCall.getCall();
        if (nonFunctionalVar && CallResolverUtilKt.isInvokeCallOnVariable(functionPsiCall) && functionPsiCall.getValueArguments().isEmpty()) {
            return variableCall.getCandidateDescriptor();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "bindCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bindReference";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "bindResolvedCall";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "unresolvedReference";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "unresolvedReferenceWrongReceiver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionExpectedError";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIfFunctionExpectedError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

