/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentRecord;

public class HFSPlusForkData
implements StructElements {
    private final byte[] logicalSize = new byte[8];
    private final byte[] clumpSize = new byte[4];
    private final byte[] totalBlocks = new byte[4];
    private final HFSPlusExtentRecord extents;

    public HFSPlusForkData(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.logicalSize, 0, 8);
        System.arraycopy(data, offset + 8, this.clumpSize, 0, 4);
        System.arraycopy(data, offset + 12, this.totalBlocks, 0, 4);
        this.extents = new HFSPlusExtentRecord(data, offset + 16);
    }

    public static int length() {
        return 80;
    }

    public long getLogicalSize() {
        return Util.readLongBE(this.logicalSize);
    }

    public long getClumpSize() {
        return Util.readIntBE(this.clumpSize);
    }

    public long getTotalBlocks() {
        return Util.readIntBE(this.totalBlocks);
    }

    public HFSPlusExtentRecord getExtents() {
        return this.extents;
    }

    public void print(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.print(ps, pregapString);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "logicalSize: " + this.getLogicalSize());
        ps.println(prefix + "clumpSize: " + this.getClumpSize());
        ps.println(prefix + "totalBlocks: " + this.getTotalBlocks());
        ps.println(prefix + "extents:");
        this.extents.print(ps, prefix + "  ");
    }

    byte[] getBytes() {
        byte[] result = new byte[HFSPlusForkData.length()];
        int offset = 0;
        System.arraycopy(this.logicalSize, 0, result, offset, this.logicalSize.length);
        System.arraycopy(this.clumpSize, 0, result, offset += this.logicalSize.length, this.clumpSize.length);
        System.arraycopy(this.totalBlocks, 0, result, offset += this.clumpSize.length, this.totalBlocks.length);
        byte[] tempData = this.extents.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.totalBlocks.length, tempData.length);
        offset += tempData.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusForkData.class.getSimpleName());
        db.addUIntBE("logicalSize", this.logicalSize);
        db.addUIntBE("clumpSize", this.clumpSize);
        db.addUIntBE("totalBlocks", this.totalBlocks);
        db.add("extents", this.extents.getStructElements());
        return db.getResult();
    }
}

