/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.relatedMatches;

import docking.widgets.label.GIconLabel;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchCorrelationType;
import ghidra.feature.vt.gui.provider.relatedMatches.VTRelatedMatchType;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RelatedMatchRenderer
extends GhidraTableCellRenderer {
    private static final Color GOOD = new GColor("color.bg.version.tracking.related.matches.table.good");
    private static final Color MEDIUM = new GColor("color.bg.version.tracking.related.matches.table.medium");
    private static final Color BAD = new GColor("color.bg.version.tracking.related.matches.table.bad");
    static Map<VTRelatedMatchCorrelationType, JLabel> sourceMap;
    static Map<VTRelatedMatchCorrelationType, JLabel> destinationMap;
    static Map<VTAssociationStatus, JLabel> statusMap;
    static final Icon TARGET_ICON;
    static final Icon CALLER_ICON;
    static final Icon CALLEE_ICON;
    static final Icon UNRELATED_ICON;
    static final Icon ACCEPTED_ICON;
    static final Icon AVAILABLE_ICON;
    static final Icon LOCKED_OUT_ICON;
    private JPanel relatedMatchColumnComponent;
    private GridLayout layout;

    public RelatedMatchRenderer() {
        RelatedMatchRenderer.initialize();
        this.relatedMatchColumnComponent = new JPanel();
        this.layout = new GridLayout(1, 3);
        this.relatedMatchColumnComponent.setLayout(this.layout);
    }

    private static void initialize() {
        if (sourceMap == null) {
            sourceMap = new HashMap<VTRelatedMatchCorrelationType, JLabel>();
            sourceMap.put(VTRelatedMatchCorrelationType.TARGET, (JLabel)new GIconLabel(TARGET_ICON));
            sourceMap.put(VTRelatedMatchCorrelationType.CALLER, (JLabel)new GIconLabel(CALLER_ICON));
            sourceMap.put(VTRelatedMatchCorrelationType.CALLEE, (JLabel)new GIconLabel(CALLEE_ICON));
            sourceMap.put(VTRelatedMatchCorrelationType.UNRELATED, (JLabel)new GIconLabel(UNRELATED_ICON));
            destinationMap = new HashMap<VTRelatedMatchCorrelationType, JLabel>();
            destinationMap.put(VTRelatedMatchCorrelationType.TARGET, (JLabel)new GIconLabel(TARGET_ICON));
            destinationMap.put(VTRelatedMatchCorrelationType.CALLER, (JLabel)new GIconLabel(CALLER_ICON));
            destinationMap.put(VTRelatedMatchCorrelationType.CALLEE, (JLabel)new GIconLabel(CALLEE_ICON));
            destinationMap.put(VTRelatedMatchCorrelationType.UNRELATED, (JLabel)new GIconLabel(UNRELATED_ICON));
            statusMap = new HashMap<VTAssociationStatus, JLabel>();
            statusMap.put(VTAssociationStatus.ACCEPTED, (JLabel)new GIconLabel(ACCEPTED_ICON));
            statusMap.put(VTAssociationStatus.AVAILABLE, (JLabel)new GIconLabel(AVAILABLE_ICON));
            statusMap.put(VTAssociationStatus.BLOCKED, (JLabel)new GIconLabel(LOCKED_OUT_ICON));
        }
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        if (value instanceof VTRelatedMatchType) {
            VTRelatedMatchType relatedMatchType = (VTRelatedMatchType)((Object)value);
            this.relatedMatchColumnComponent.removeAll();
            this.relatedMatchColumnComponent.add(sourceMap.get((Object)relatedMatchType.getSourceType()));
            this.relatedMatchColumnComponent.add(destinationMap.get((Object)relatedMatchType.getDestinationType()));
            this.relatedMatchColumnComponent.add(statusMap.get((Object)relatedMatchType.getAssociationStatus()));
            Color bgColor = this.findBackgroundColor(relatedMatchType);
            if (bgColor != null) {
                this.relatedMatchColumnComponent.setBackground(bgColor);
            }
            return this.relatedMatchColumnComponent;
        }
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        renderer.setToolTipText(null);
        return renderer;
    }

    private Color findBackgroundColor(VTRelatedMatchType value) {
        double goodness = (double)value.getGoodness() / 100.0;
        double badness = 1.0 - goodness;
        Color color1 = goodness > 0.5 ? GOOD : MEDIUM;
        Color color2 = goodness > 0.5 ? MEDIUM : BAD;
        double red = (double)color1.getRed() * goodness + (double)color2.getRed() * badness;
        double grn = (double)color1.getGreen() * goodness + (double)color2.getGreen() * badness;
        double blu = (double)color1.getBlue() * goodness + (double)color2.getBlue() * badness;
        return new Color((int)red, (int)grn, (int)blu);
    }

    static {
        TARGET_ICON = new GIcon("icon.version.tracking.related.match.target");
        CALLER_ICON = new GIcon("icon.version.tracking.related.match.caller");
        CALLEE_ICON = new GIcon("icon.version.tracking.related.match.callee");
        UNRELATED_ICON = new GIcon("icon.version.tracking.related.match.unrelated");
        ACCEPTED_ICON = new GIcon("icon.version.tracking.related.match.accepted");
        AVAILABLE_ICON = new GIcon("icon.version.tracking.related.match.available");
        LOCKED_OUT_ICON = new GIcon("icon.version.tracking.related.match.locked.out");
    }
}

