/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;
import java.util.List;
import java.util.stream.Collectors;

public class CallExpr
extends Expr {
    private final StructuredSleigh.UseropDecl userop;
    private final List<RValInternal> args;

    private CallExpr(StructuredSleigh ctx, DataType type, StructuredSleigh.UseropDecl userop, List<RValInternal> args) {
        super(ctx, type);
        this.userop = userop;
        this.args = args;
    }

    protected CallExpr(StructuredSleigh ctx, StructuredSleigh.UseropDecl userop, List<StructuredSleigh.RVal> args) {
        this(ctx, userop.getReturnType(), userop, args.stream().map(a -> (RValInternal)a).collect(Collectors.toList()));
    }

    @Override
    public StructuredSleigh.RVal cast(DataType type) {
        return new CallExpr(this.ctx, type, this.userop, this.args);
    }

    public String toString() {
        return "<Call " + this.userop.getName() + "(" + this.args.stream().map(a -> a.toString()).collect(Collectors.joining(",")) + ")>";
    }

    @Override
    public StringTree generate(RValInternal parent) {
        StringTree st = new StringTree();
        st.append(this.userop.getName());
        st.append("(");
        boolean first = false;
        for (RValInternal a : this.args) {
            if (!first) {
                first = true;
            } else {
                st.append(",");
            }
            st.append(a.generate(this));
        }
        st.append(")");
        return st;
    }
}

