/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.unix.EmuUnixFileStat;
import ghidra.pcode.emu.unix.EmuUnixUser;
import ghidra.pcode.exec.PcodeArithmetic;

public interface EmuUnixFile<T> {
    public String getPathname();

    public T read(PcodeArithmetic<T> var1, T var2, T var3);

    public T write(PcodeArithmetic<T> var1, T var2, T var3);

    public void truncate();

    public EmuUnixFileStat getStat();

    default public boolean isReadable(EmuUnixUser user) {
        return this.getStat().hasPermissions(4, user);
    }

    default public boolean isWritable(EmuUnixUser user) {
        return this.getStat().hasPermissions(2, user);
    }

    default public void checkReadable(EmuUnixUser user) {
        if (!this.isReadable(user)) {
            throw new EmuIOException("The file " + this.getPathname() + " cannot be read.");
        }
    }

    default public void checkWritable(EmuUnixUser user) {
        if (!this.isWritable(user)) {
            throw new EmuIOException("The file " + this.getPathname() + " cannot be written.");
        }
    }
}

