/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MdmpFileHeader
implements StructConverter {
    public static final String NAME = "MINIDUMP_HEADER";
    private int signature;
    private int version;
    private int numberOfStreams;
    private long streamDirectoryRVA;
    private int checkSum;
    private int timeDateStamp;
    private long flags;
    private DumpFileReader reader;
    private long index;

    MdmpFileHeader(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setVersion(this.reader.readNextInt());
        this.setNumberOfStreams(this.reader.readNextInt());
        this.setStreamDirectoryRVA(this.reader.readNextInt());
        this.setCheckSum(this.reader.readNextInt());
        this.setTimeDateStamp(this.reader.readNextInt());
        this.setFlags(this.reader.readNextLong());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(STRING, 4, "Signature", null);
        struct.add(STRING, 4, "Version", null);
        struct.add(DWORD, 4, "NumberOfStreams", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "StreamDirectoryRVA", null);
        struct.add(DWORD, 4, "CheckSum", null);
        UnionDataType union = new UnionDataType("MINIDUMP_HEADER_u");
        union.add(DWORD, 4, "Reserved", null);
        union.add(DWORD, 4, "TimeDateStamp", null);
        struct.add((DataType)union, 4, union.getDisplayName(), null);
        struct.add(QWORD, 8, "Flags", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void setNumberOfStreams(int numberOfStreams) {
        this.numberOfStreams = numberOfStreams;
    }

    public int getNumberOfStreams() {
        return this.numberOfStreams;
    }

    public void setStreamDirectoryRVA(long streamDirectoryRVA) {
        this.streamDirectoryRVA = streamDirectoryRVA;
    }

    public long getStreamDirectoryRVA() {
        return this.streamDirectoryRVA;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setTimeDateStamp(int timeDateStamp) {
        this.timeDateStamp = timeDateStamp;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public long getFlags() {
        return this.flags;
    }
}

