/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.datatable.ProjectTreeAction;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;
import resources.MultiIcon;

public class ProjectDataPasteLinkAction
extends ProjectTreeAction {
    private static Icon baseIcon = Icons.PASTE_ICON;

    public ProjectDataPasteLinkAction(String owner, String group) {
        super("Paste Link", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Paste as Link"}, ProjectDataPasteLinkAction.getIcon(), group));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Create_File_Links"));
    }

    private static Icon getIcon() {
        MultiIcon multiIcon = new MultiIcon(baseIcon);
        multiIcon.addIcon(LinkHandler.LINK_ICON);
        return multiIcon;
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        GTreeNode copyNode;
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolderNode destNode = this.getFolderForNode(node);
        if (!this.isEnabledForContext(context)) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Unsupported Operation", (Object)"Unsupported paste link condition");
        }
        if ((copyNode = this.getFolderOrFileCopyNode()) instanceof DomainFileNode) {
            try {
                DomainFile domainFile = ((DomainFileNode)copyNode).getDomainFile();
                domainFile.copyToAsLink(destNode.getDomainFolder());
            }
            catch (IOException e) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Cannot Create Link", (Object)"Error occured while creating link file", (Throwable)e);
            }
        } else {
            try {
                DomainFolder domainFolder = ((DomainFolderNode)copyNode).getDomainFolder();
                domainFolder.copyToAsLink(destNode.getDomainFolder());
            }
            catch (IOException e) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Cannot Create Link", (Object)"Error occured while creating link file", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolderNode destNode = this.getFolderForNode(node);
        GTreeNode copyNode = this.getFolderOrFileCopyNode();
        if (copyNode == null || copyNode.getParent() == null) {
            return false;
        }
        if (destNode.getRoot() == copyNode.getRoot()) {
            return false;
        }
        if (copyNode instanceof DomainFileNode) {
            DomainFile df = ((DomainFileNode)copyNode).getDomainFile();
            return df.isLinkingSupported();
        }
        return true;
    }

    @Override
    protected boolean isAddToPopup(FrontEndProjectTreeContext context) {
        if (!context.hasOneOrMoreFilesAndFolders()) {
            return false;
        }
        if (!context.isInActiveProject()) {
            return false;
        }
        GTreeNode copyNode = this.getFolderOrFileCopyNode();
        return copyNode != null && copyNode.getParent() != null;
    }

    private DomainFolderNode getFolderForNode(GTreeNode node) {
        if (node instanceof DomainFolderNode) {
            return (DomainFolderNode)node;
        }
        return (DomainFolderNode)node.getParent();
    }

    private GTreeNode getFolderOrFileCopyNode() {
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        if (list.size() != 1) {
            return null;
        }
        GTreeNode copyNode = list.get(0);
        if (copyNode instanceof DomainFileNode && !((DomainFileNode)copyNode).isCut()) {
            return copyNode;
        }
        if (copyNode instanceof DomainFolderNode && !((DomainFolderNode)copyNode).isCut()) {
            return copyNode;
        }
        return null;
    }
}

