/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortingContext;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class TableData<ROW_OBJECT>
implements Iterable<ROW_OBJECT> {
    private static int nextID = 0;
    private TableData<ROW_OBJECT> source = null;
    private List<ROW_OBJECT> data = Collections.emptyList();
    private volatile TableSortingContext<ROW_OBJECT> sortContext;
    private TableFilter<ROW_OBJECT> tableFilter;
    private int ID = ++nextID;

    static <ROW_OBJECT> TableData<ROW_OBJECT> createEmptyDataset() {
        return new TableData<ROW_OBJECT>();
    }

    static <ROW_OBJECT> TableData<ROW_OBJECT> createFullDataset(List<ROW_OBJECT> data) {
        return new TableData<ROW_OBJECT>(data, null);
    }

    static <ROW_OBJECT> TableData<ROW_OBJECT> createSubDataset(TableData<ROW_OBJECT> source, List<ROW_OBJECT> derived, TableSortingContext<ROW_OBJECT> sortContext) {
        return new TableData<ROW_OBJECT>(source, derived, sortContext);
    }

    private TableData() {
    }

    TableData(List<ROW_OBJECT> data, TableSortingContext<ROW_OBJECT> sortContext) {
        this.data = data;
        this.sortContext = sortContext;
    }

    private TableData(TableData<ROW_OBJECT> source, List<ROW_OBJECT> derived, TableSortingContext<ROW_OBJECT> sortContext) {
        this.source = source;
        this.data = derived;
        this.sortContext = sortContext;
    }

    TableData<ROW_OBJECT> copy() {
        return this.copy(this.source);
    }

    TableData<ROW_OBJECT> copy(TableData<ROW_OBJECT> newSource) {
        ArrayList<ROW_OBJECT> dataCopy = new ArrayList<ROW_OBJECT>(this.data);
        TableData<ROW_OBJECT> newData = new TableData<ROW_OBJECT>(dataCopy, this.sortContext);
        newData.source = newSource;
        newData.tableFilter = this.tableFilter;
        newData.ID = this.ID;
        return newData;
    }

    TableFilter<ROW_OBJECT> getTableFilter() {
        return this.tableFilter;
    }

    void setTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.tableFilter = tableFilter;
    }

    TableSortingContext<ROW_OBJECT> getSortContext() {
        return this.sortContext;
    }

    boolean isSorted() {
        return this.sortContext != null && !this.sortContext.isUnsorted();
    }

    void setSortContext(TableSortingContext<ROW_OBJECT> sortContext) {
        this.sortContext = sortContext;
    }

    List<ROW_OBJECT> getData() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    void clear() {
        this.data.clear();
    }

    public ROW_OBJECT get(int modelRow) {
        return this.data.get(modelRow);
    }

    public int indexOf(ROW_OBJECT t) {
        if (this.isSorted()) {
            Comparator<ROW_OBJECT> comparator = this.sortContext.getComparator();
            return Collections.binarySearch(this.data, t, comparator);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            ROW_OBJECT item = this.data.get(i);
            if (!t.equals(item)) continue;
            return i;
        }
        return -1;
    }

    public boolean remove(ROW_OBJECT t) {
        if (this.source != null) {
            this.source.remove(t);
        }
        if (!this.isSorted()) {
            return this.data.remove(t);
        }
        Comparator<ROW_OBJECT> comparator = this.sortContext.getComparator();
        int index = Collections.binarySearch(this.data, t, comparator);
        if (index >= 0) {
            this.data.remove(index);
            return true;
        }
        return false;
    }

    public void process(BiFunction<List<ROW_OBJECT>, TableSortingContext<ROW_OBJECT>, List<ROW_OBJECT>> function) {
        if (!this.isSorted()) {
            return;
        }
        if (this.source != null) {
            this.source.process(function);
        }
        this.data = function.apply(this.data, this.sortContext);
    }

    public void insert(ROW_OBJECT value) {
        if (this.source != null) {
            this.source.insert(value);
        }
        if (!this.passesFilter(value)) {
            return;
        }
        if (!this.isSorted()) {
            this.data.add(value);
            return;
        }
        Comparator<ROW_OBJECT> comparator = this.sortContext.getComparator();
        int index = Collections.binarySearch(this.data, value, comparator);
        if (index < 0) {
            index = -index - 1;
            this.data.add(index, value);
            return;
        }
        ROW_OBJECT existingValue = this.data.get(index);
        if (!Objects.equals(value, existingValue)) {
            this.data.add(index, value);
        }
    }

    private boolean passesFilter(ROW_OBJECT value) {
        if (this.tableFilter == null) {
            return true;
        }
        return this.tableFilter.acceptsRow(value);
    }

    TableData<ROW_OBJECT> getLowestLevelSourceDataForFilter(TableFilter<ROW_OBJECT> filter) {
        if (this.hasParentFilterOf(filter)) {
            return this;
        }
        if (this.source == null) {
            return null;
        }
        TableData<ROW_OBJECT> parent = this.source.getLowestLevelSourceDataForFilter(filter);
        return parent;
    }

    private boolean hasParentFilterOf(TableFilter<ROW_OBJECT> filter) {
        if (this.tableFilter == null) {
            return false;
        }
        if (filter == null) {
            return false;
        }
        boolean isSubFilter = filter.isSubFilterOf(this.tableFilter);
        return isSubFilter;
    }

    boolean matchesFilter(TableFilter<ROW_OBJECT> filter) {
        return SystemUtilities.isEqual(this.tableFilter, filter);
    }

    boolean isUnrelatedTo(TableData<ROW_OBJECT> other) {
        if (other == null) {
            return this.source != null;
        }
        if (other.ID == this.ID) {
            return false;
        }
        if (this.source == null) {
            return true;
        }
        return this.source.isUnrelatedTo(other);
    }

    int getId() {
        return this.ID;
    }

    TableData<ROW_OBJECT> getRootData() {
        if (this.source == null) {
            return this;
        }
        return this.source.getRootData();
    }

    @Override
    public Iterator<ROW_OBJECT> iterator() {
        return this.data.iterator();
    }

    public String toString() {
        return "{\n\tderived? " + (this.source != null) + ",\n\tdata:\t" + String.valueOf(this.data) + "\n,\tsort:\t" + (this.sortContext == null ? "" : this.sortContext.toString()) + ",\n}";
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

