/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.items.CompositeFieldQuickFix;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class UpdateFieldCommentQuickFix
extends CompositeFieldQuickFix {
    private String fieldName;

    public UpdateFieldCommentQuickFix(Program program, Composite composite, String fieldName, int ordinal, String original, String newComment) {
        super(program, composite, ordinal, original, newComment);
        this.fieldName = fieldName;
    }

    @Override
    public String getActionName() {
        return "Update";
    }

    @Override
    public String getItemType() {
        return "Field Comment";
    }

    @Override
    public String doGetCurrent() {
        DataTypeComponent component = this.findComponent(this.fieldName);
        return component == null ? null : component.getComment();
    }

    @Override
    public void execute() {
        DataTypeComponent component = this.findComponent(this.fieldName);
        try {
            component.setComment(this.replacement);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Update field comment failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected String getFieldName() {
        return this.fieldName;
    }
}

