/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Category;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.util.Map;

public class RenameCategoryQuickFix
extends RenameQuickFix {
    private Category category;

    public RenameCategoryQuickFix(Program program, Category category, String newName) {
        super(program, category.getName(), newName);
        this.category = category;
        this.checkForDuplicates();
    }

    private void checkForDuplicates() {
        Category parent = this.category.getParent();
        if (parent == null) {
            return;
        }
        if (parent.getCategory(this.replacement) != null) {
            this.setStatus(QuickFixStatus.WARNING, "The name \"" + this.replacement + "\" already exists in category \"" + parent.getCategoryPathName() + "\"");
        }
    }

    @Override
    public void statusChanged(QuickFixStatus newStatus) {
        if (newStatus == QuickFixStatus.NONE) {
            this.checkForDuplicates();
        }
    }

    @Override
    public String getItemType() {
        return "datatype category";
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public String getPath() {
        return this.category.getParent().getCategoryPathName();
    }

    @Override
    protected String doGetCurrent() {
        return this.category.getName();
    }

    @Override
    protected void execute() {
        try {
            this.category.setName(this.replacement);
        }
        catch (InvalidNameException | DuplicateNameException e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename Failed! " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setCategorySelected(this.category);
        return true;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Parent Path", this.category.getParent().getCategoryPathName());
    }
}

