/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pef.ExportedSymbol;
import ghidra.app.util.bin.format.pef.ExportedSymbolHashSlot;
import ghidra.app.util.bin.format.pef.ExportedSymbolKey;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.LoaderRelocationHeader;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LoaderInfoHeader
implements StructConverter {
    public static final int SIZEOF = 56;
    private SectionHeader _section;
    private int mainSection;
    private int mainOffset;
    private int initSection;
    private int initOffset;
    private int termSection;
    private int termOffset;
    private int importedLibraryCount;
    private int totalImportedSymbolCount;
    private int relocSectionCount;
    private int relocInstrOffset;
    private int loaderStringsOffset;
    private int exportHashOffset;
    private int exportHashTablePower;
    private int exportedSymbolCount;
    private List<ImportedLibrary> _importedLibraries = new ArrayList<ImportedLibrary>();
    private List<ImportedSymbol> _importedSymbols = new ArrayList<ImportedSymbol>();
    private List<LoaderRelocationHeader> _relocations = new ArrayList<LoaderRelocationHeader>();
    private List<ExportedSymbolHashSlot> _exportedHashSlots = new ArrayList<ExportedSymbolHashSlot>();
    private List<ExportedSymbolKey> _exportedSymbolKeys = new ArrayList<ExportedSymbolKey>();
    private List<ExportedSymbol> _exportedSymbols = new ArrayList<ExportedSymbol>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoaderInfoHeader(BinaryReader reader, SectionHeader section) throws IOException {
        this._section = section;
        long oldIndex = reader.getPointerIndex();
        try {
            int i;
            int i2;
            reader.setPointerIndex(section.getContainerOffset());
            this.mainSection = reader.readNextInt();
            this.mainOffset = reader.readNextInt();
            this.initSection = reader.readNextInt();
            this.initOffset = reader.readNextInt();
            this.termSection = reader.readNextInt();
            this.termOffset = reader.readNextInt();
            this.importedLibraryCount = reader.readNextInt();
            this.totalImportedSymbolCount = reader.readNextInt();
            this.relocSectionCount = reader.readNextInt();
            this.relocInstrOffset = reader.readNextInt();
            this.loaderStringsOffset = reader.readNextInt();
            this.exportHashOffset = reader.readNextInt();
            this.exportHashTablePower = reader.readNextInt();
            this.exportedSymbolCount = reader.readNextInt();
            for (i2 = 0; i2 < this.importedLibraryCount; ++i2) {
                this._importedLibraries.add(new ImportedLibrary(reader, this));
            }
            for (i2 = 0; i2 < this.totalImportedSymbolCount; ++i2) {
                this._importedSymbols.add(new ImportedSymbol(reader, this));
            }
            for (i2 = 0; i2 < this.relocSectionCount; ++i2) {
                this._relocations.add(new LoaderRelocationHeader(reader, this));
            }
            int exportIndex = section.getContainerOffset() + this.exportHashOffset;
            reader.setPointerIndex(exportIndex);
            int nExported = (int)Math.pow(2.0, this.exportHashTablePower);
            for (i = 0; i < nExported; ++i) {
                this._exportedHashSlots.add(new ExportedSymbolHashSlot(reader));
            }
            for (i = 0; i < this.exportedSymbolCount; ++i) {
                this._exportedSymbolKeys.add(new ExportedSymbolKey(reader));
            }
            for (i = 0; i < this.exportedSymbolCount; ++i) {
                this._exportedSymbols.add(new ExportedSymbol(reader, this, this._exportedSymbolKeys.get(i)));
            }
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    public int getMainSection() {
        return this.mainSection;
    }

    public int getMainOffset() {
        return this.mainOffset;
    }

    public int getInitSection() {
        return this.initSection;
    }

    public int getInitOffset() {
        return this.initOffset;
    }

    public int getTermSection() {
        return this.termSection;
    }

    public int getTermOffset() {
        return this.termOffset;
    }

    public int getImportedLibraryCount() {
        return this.importedLibraryCount;
    }

    public int getTotalImportedSymbolCount() {
        return this.totalImportedSymbolCount;
    }

    public int getRelocSectionCount() {
        return this.relocSectionCount;
    }

    public int getRelocInstrOffset() {
        return this.relocInstrOffset;
    }

    public int getLoaderStringsOffset() {
        return this.loaderStringsOffset;
    }

    public int getExportHashOffset() {
        return this.exportHashOffset;
    }

    public int getExportHashTablePower() {
        return this.exportHashTablePower;
    }

    public int getExportedSymbolCount() {
        return this.exportedSymbolCount;
    }

    public SectionHeader getSection() {
        return this._section;
    }

    public ImportedLibrary findLibrary(int symbolIndex) {
        for (ImportedLibrary library : this._importedLibraries) {
            if (symbolIndex < library.getFirstImportedSymbol() || symbolIndex >= library.getFirstImportedSymbol() + library.getImportedSymbolCount()) continue;
            return library;
        }
        return null;
    }

    public List<ImportedLibrary> getImportedLibraries() {
        return this._importedLibraries;
    }

    public List<ImportedSymbol> getImportedSymbols() {
        return this._importedSymbols;
    }

    public List<LoaderRelocationHeader> getRelocations() {
        return this._relocations;
    }

    public List<ExportedSymbolHashSlot> getExportedHashSlots() {
        return this._exportedHashSlots;
    }

    public List<ExportedSymbolKey> getExportedSymbolKeys() {
        return this._exportedSymbolKeys;
    }

    public List<ExportedSymbol> getExportedSymbols() {
        return this._exportedSymbols;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this.getClass());
    }
}

