/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.prevayler.foundation.FileManager;

public class PrevaylerDirectory {
    private static final int DIGITS_IN_FILENAME = 19;
    private static final String SNAPSHOT_SUFFIX_PATTERN = "[a-zA-Z0-9]*[Ss]napshot";
    private static final String SNAPSHOT_FILENAME_PATTERN = "\\d{19}\\.[a-zA-Z0-9]*[Ss]napshot";
    private static final String JOURNAL_SUFFIX_PATTERN = "[a-zA-Z0-9]*[Jj]ournal";
    private static final String JOURNAL_FILENAME_PATTERN = "\\d{19}\\.[a-zA-Z0-9]*[Jj]ournal";
    private File _directory;

    public PrevaylerDirectory(String directory) {
        this(new File(directory));
    }

    public PrevaylerDirectory(File directory) {
        this._directory = directory;
    }

    public void produceDirectory() throws IOException {
        FileManager.produceDirectory(this._directory);
    }

    public static void checkValidSnapshotSuffix(String suffix) {
        if (!suffix.matches(SNAPSHOT_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException("Snapshot filename suffix must match /[a-zA-Z0-9]*[Ss]napshot/, but '" + suffix + "' does not");
        }
    }

    public static void checkValidJournalSuffix(String suffix) {
        if (!suffix.matches(JOURNAL_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException("Journal filename suffix must match /[a-zA-Z0-9]*[Jj]ournal/, but '" + suffix + "' does not");
        }
    }

    public File snapshotFile(long version, String suffix) {
        PrevaylerDirectory.checkValidSnapshotSuffix(suffix);
        return this.file(version, suffix);
    }

    public File journalFile(long transaction, String suffix) {
        PrevaylerDirectory.checkValidJournalSuffix(suffix);
        return this.file(transaction, suffix);
    }

    private File file(long version, String suffix) {
        if (version < 0L) {
            throw new IllegalArgumentException("Snapshot and journal version numbers must be non-negative: " + version);
        }
        String fileName = "0000000000000000000" + version;
        return new File(this._directory, fileName.substring(fileName.length() - 19) + "." + suffix);
    }

    public static long snapshotVersion(File file) {
        return PrevaylerDirectory.version(file, SNAPSHOT_FILENAME_PATTERN);
    }

    public static long journalVersion(File file) {
        return PrevaylerDirectory.version(file, JOURNAL_FILENAME_PATTERN);
    }

    private static long version(File file, String filenamePattern) {
        String fileName = file.getName();
        if (!fileName.matches(filenamePattern)) {
            return -1L;
        }
        return Long.parseLong(fileName.substring(0, fileName.indexOf(".")));
    }

    public File latestSnapshot() throws IOException {
        File[] files = this._directory.listFiles();
        if (files == null) {
            throw new IOException("Error reading file list from directory " + this._directory);
        }
        File latestSnapshot = null;
        long latestVersion = -1L;
        for (int i = 0; i < files.length; ++i) {
            File candidateSnapshot = files[i];
            long candidateVersion = PrevaylerDirectory.snapshotVersion(candidateSnapshot);
            if (candidateVersion <= latestVersion) continue;
            latestVersion = candidateVersion;
            latestSnapshot = candidateSnapshot;
        }
        return latestSnapshot;
    }

    public File findInitialJournalFile(long initialTransactionWanted) {
        File[] journals = this._directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches(PrevaylerDirectory.JOURNAL_FILENAME_PATTERN);
            }
        });
        Arrays.sort(journals, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return new Long(PrevaylerDirectory.journalVersion(f1)).compareTo(new Long(PrevaylerDirectory.journalVersion(f2)));
            }
        });
        for (int i = journals.length - 1; i >= 0; --i) {
            File journal = journals[i];
            long version = PrevaylerDirectory.journalVersion(journal);
            if (version > initialTransactionWanted) continue;
            return journal;
        }
        return null;
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, this._directory);
    }

    public static void renameUnusedFile(File journalFile) {
        journalFile.renameTo(new File(journalFile.getAbsolutePath() + ".unusedFile" + System.currentTimeMillis()));
    }

    public Set necessaryFiles() throws IOException {
        File[] allFiles = this._directory.listFiles();
        if (allFiles == null) {
            throw new IOException("Error reading file list from directory " + this._directory);
        }
        File latestSnapshot = this.latestSnapshot();
        long systemVersion = latestSnapshot == null ? 0L : PrevaylerDirectory.snapshotVersion(latestSnapshot);
        File initialJournal = this.findInitialJournalFile(systemVersion + 1L);
        TreeSet<File> neededFiles = new TreeSet<File>();
        if (latestSnapshot != null) {
            neededFiles.add(latestSnapshot);
        }
        if (initialJournal != null) {
            neededFiles.add(initialJournal);
            long initialJournalVersion = PrevaylerDirectory.journalVersion(initialJournal);
            for (int i = 0; i < allFiles.length; ++i) {
                File file = allFiles[i];
                if (PrevaylerDirectory.journalVersion(file) <= initialJournalVersion) continue;
                neededFiles.add(file);
            }
        }
        return neededFiles;
    }
}

