/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public interface InternalDataTypeComponent
extends DataTypeComponent {
    public void setDataType(DataType var1);

    public void update(int var1, int var2, int var3);

    public static String toString(DataTypeComponent c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  " + c.getOrdinal());
        buffer.append("  " + c.getOffset());
        buffer.append("  " + c.getDataType().getName());
        if (c.isBitFieldComponent()) {
            buffer.append("(" + ((BitFieldDataType)c.getDataType()).getBitOffset() + ")");
        }
        buffer.append("  " + c.getLength());
        String name = c.getFieldName();
        if (name == null) {
            name = "";
        }
        buffer.append("  " + name);
        String cmt = c.getComment();
        buffer.append("  " + (String)(cmt != null ? "\"" + cmt + "\"" : ""));
        return buffer.toString();
    }

    default public String cleanupFieldName(String name) {
        String fieldName = StringUtilities.whitespaceToUnderscores((String)name);
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            fieldName = null;
        }
        return fieldName;
    }
}

