/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.ClipBridge;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FilterBridge;
import io.sf.carte.echosvg.bridge.MaskBridge;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.constants.XMLConstants;
import io.sf.carte.echosvg.css.CSSSecurityException;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.ext.awt.MultipleGradientPaint;
import io.sf.carte.echosvg.ext.awt.image.renderable.ClipRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.filter.Mask;
import io.sf.carte.echosvg.util.CSSConstants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public abstract class CSSUtilities
implements CSSConstants,
ErrorConstants,
XMLConstants {
    public static final Composite TRANSPARENT = AlphaComposite.getInstance(3, 0.0f);

    protected CSSUtilities() {
    }

    public static CSSEngine getCSSEngine(Element element) {
        return ((SVGOMDocument)element.getOwnerDocument()).getCSSEngine();
    }

    public static Value getComputedStyle(Element element, int n) throws CSSSecurityException {
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        if (cSSEngine == null) {
            return null;
        }
        return cSSEngine.getComputedStyle((CSSStylableElement)element, null, n);
    }

    public static int convertPointerEvents(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 44);
        String string = value.getIdentifierValue();
        switch (string.charAt(0)) {
            case 'v': {
                if (string.length() == 7) {
                    return 3;
                }
                switch (string.charAt(7)) {
                    case 'p': {
                        return 0;
                    }
                    case 'f': {
                        return 1;
                    }
                    case 's': {
                        return 2;
                    }
                }
                throw new IllegalStateException("unexpected event, must be one of (p,f,s) is:" + string.charAt(7));
            }
            case 'p': {
                return 4;
            }
            case 'f': {
                return 5;
            }
            case 's': {
                return 6;
            }
            case 'a': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        throw new IllegalStateException("unexpected event, must be one of (v,p,f,s,a,n) is:" + string.charAt(0));
    }

    public static Rectangle2D convertEnableBackground(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 13);
        if (value.getCssValueType() != CSSValue.CssType.LIST) {
            return null;
        }
        int n = value.getLength();
        switch (n) {
            case 1: {
                return CompositeGraphicsNode.VIEWPORT;
            }
            case 5: {
                float f = value.item(1).getFloatValue();
                float f2 = value.item(2).getFloatValue();
                float f3 = value.item(3).getFloatValue();
                float f4 = value.item(4).getFloatValue();
                return new Rectangle2D.Float(f, f2, f3, f4);
            }
        }
        throw new IllegalStateException("Unexpected length:" + n);
    }

    public static boolean convertColorInterpolationFilters(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 7);
        return "linearrgb" == value.getIdentifierValue();
    }

    public static MultipleGradientPaint.ColorSpaceEnum convertColorInterpolation(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 6);
        return "linearrgb" == value.getIdentifierValue() ? MultipleGradientPaint.LINEAR_RGB : MultipleGradientPaint.SRGB;
    }

    public static boolean isAutoCursor(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 9);
        boolean bl = false;
        if (value != null) {
            Value value2;
            if (value.getPrimitiveType() == CSSValue.Type.IDENT && value.getIdentifierValue().charAt(0) == 'a') {
                bl = true;
            } else if (value.getCssValueType() == CSSValue.CssType.LIST && value.getLength() == 1 && (value2 = value.item(0)) != null && value2.getPrimitiveType() == CSSValue.Type.IDENT && value2.getIdentifierValue().charAt(0) == 'a') {
                bl = true;
            }
        }
        return bl;
    }

    public static Cursor convertCursor(Element element, BridgeContext bridgeContext) {
        return bridgeContext.getCursorManager().convertCursor(element);
    }

    public static RenderingHints convertShapeRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 46);
        String string = value.getIdentifierValue();
        int n = string.length();
        if (n == 4 && string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (n < 10) {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(0)) {
            case 'o': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'c': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'g': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertTextRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 59);
        String string = value.getIdentifierValue();
        int n = string.length();
        if (n == 4 && string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (n < 13) {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                break;
            }
            case 'l': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                break;
            }
            case 'c': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertImageRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 29);
        String string = value.getIdentifierValue();
        int n = string.length();
        if (n == 4 && string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (n < 13) {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case 'q': {
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
        return renderingHints;
    }

    public static RenderingHints convertColorRendering(Element element, RenderingHints renderingHints) {
        Value value = CSSUtilities.getComputedStyle(element, 8);
        String string = value.getIdentifierValue();
        int n = string.length();
        if (n == 4 && string.charAt(0) == 'a') {
            return renderingHints;
        }
        if (n < 13) {
            return renderingHints;
        }
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        switch (string.charAt(8)) {
            case 's': {
                renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                break;
            }
            case 'q': {
                renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            }
        }
        return renderingHints;
    }

    public static boolean convertDisplay(Element element) {
        if (!(element instanceof CSSStylableElement)) {
            return true;
        }
        Value value = CSSUtilities.getComputedStyle(element, 11);
        return value.getIdentifierValue().charAt(0) != 'n';
    }

    public static boolean convertVisibility(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 61);
        return value.getIdentifierValue().charAt(0) == 'v';
    }

    public static Composite convertOpacity(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 42);
        float f = value.getFloatValue();
        if (f <= 0.0f) {
            return TRANSPARENT;
        }
        if (f >= 1.0f) {
            return AlphaComposite.SrcOver;
        }
        return AlphaComposite.getInstance(3, f);
    }

    public static boolean convertOverflow(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 43);
        String string = value.getIdentifierValue();
        return string.charAt(0) == 'h' || string.charAt(0) == 's';
    }

    public static float[] convertClip(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 2);
        switch (value.getPrimitiveType()) {
            case RECT: {
                float[] fArray = new float[4];
                RectValue rectValue = value.getRectValue();
                fArray[0] = rectValue.getTop().getFloatValue();
                fArray[1] = rectValue.getRight().getFloatValue();
                fArray[2] = rectValue.getBottom().getFloatValue();
                fArray[3] = rectValue.getLeft().getFloatValue();
                return fArray;
            }
            case IDENT: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected primitiveType: " + value.getPrimitiveType());
    }

    public static Filter convertFilter(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 17);
        CSSValue.Type type = value.getPrimitiveType();
        switch (type) {
            case IDENT: {
                return null;
            }
            case URI: {
                String string = value.getURIValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                if (element2 == null) {
                    return null;
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof FilterBridge)) {
                    BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
                    UserAgent userAgent = bridgeContext.getUserAgent();
                    if (userAgent == null) {
                        throw bridgeException;
                    }
                    userAgent.displayError(bridgeException);
                    return null;
                }
                return ((FilterBridge)bridge).createFilter(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + type);
    }

    public static ClipRable convertClipPath(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 3);
        CSSValue.Type type = value.getPrimitiveType();
        switch (type) {
            case IDENT: {
                return null;
            }
            case URI: {
                String string = value.getURIValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                if (element2 == null) {
                    return null;
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof ClipBridge)) {
                    BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
                    UserAgent userAgent = bridgeContext.getUserAgent();
                    if (userAgent == null) {
                        throw bridgeException;
                    }
                    userAgent.displayError(bridgeException);
                    return null;
                }
                return ((ClipBridge)bridge).createClip(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + type);
    }

    public static int convertClipRule(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 4);
        return value.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Mask convertMask(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 41);
        CSSValue.Type type = value.getPrimitiveType();
        switch (type) {
            case IDENT: {
                return null;
            }
            case URI: {
                String string = value.getURIValue();
                Element element2 = bridgeContext.getReferencedElement(element, string);
                if (element2 == null) {
                    return null;
                }
                Bridge bridge = bridgeContext.getBridge(element2);
                if (bridge == null) {
                    return null;
                }
                if (!(bridge instanceof MaskBridge)) {
                    BridgeException bridgeException = new BridgeException(bridgeContext, element, "css.uri.badTarget", new Object[]{string});
                    UserAgent userAgent = bridgeContext.getUserAgent();
                    if (userAgent == null) {
                        throw bridgeException;
                    }
                    userAgent.displayError(bridgeException);
                    return null;
                }
                return ((MaskBridge)bridge).createMask(bridgeContext, element2, element, graphicsNode);
            }
        }
        throw new IllegalStateException("Unexpected primitive type:" + type);
    }

    public static int convertFillRule(Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 16);
        return value.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }

    public static Color convertLightingColor(Element element, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 32);
        return PaintServer.convertColor(value.getColorValue(), 1.0f, bridgeContext);
    }

    public static Color convertFloodColor(Element element, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 18);
        Value value2 = CSSUtilities.getComputedStyle(element, 19);
        float f = PaintServer.convertOpacity(value2);
        return PaintServer.convertColor(value.getColorValue(), f, bridgeContext);
    }

    public static Color convertStopColor(Element element, float f, BridgeContext bridgeContext) {
        Value value = CSSUtilities.getComputedStyle(element, 47);
        Value value2 = CSSUtilities.getComputedStyle(element, 48);
        return PaintServer.convertColor(value.getColorValue(), f *= PaintServer.convertOpacity(value2), bridgeContext);
    }

    public static void computeStyleAndURIs(Element element, Element element2, String string) {
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.length() != 0) {
            element2.setAttributeNS("http://www.w3.org/XML/1998/namespace", "base", string);
        }
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element2);
        CSSEngine cSSEngine2 = CSSUtilities.getCSSEngine(element);
        cSSEngine.importCascadedStyleMaps(element, cSSEngine2, element2);
    }

    protected static int rule(Value value) {
        return value.getIdentifierValue().charAt(0) == 'n' ? 1 : 0;
    }
}

