/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.ButtonModel;

public class ButtonGroup {
    private ButtonModel selectedModel;
    private ButtonModel defaultModel;
    private final List<ButtonModel> members = new ArrayList<ButtonModel>();
    private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public void add(ButtonModel model) {
        if (!this.members.contains(model)) {
            model.setGroup(this);
            this.members.add(model);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "selected", oldValue, newValue);
        this.listeners.forEach(listener -> listener.propertyChange(event));
    }

    public ButtonModel getDefault() {
        return this.defaultModel;
    }

    public List<ButtonModel> getElements() {
        return this.members;
    }

    public ButtonModel getSelected() {
        return this.selectedModel;
    }

    public boolean isSelected(ButtonModel model) {
        return model == this.getSelected();
    }

    public void remove(ButtonModel model) {
        if (this.getSelected() == model) {
            this.setSelected(this.getDefault(), true);
        }
        if (this.defaultModel == model) {
            this.defaultModel = null;
        }
        this.members.remove(model);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void selectNewModel(ButtonModel model) {
        ButtonModel oldModel = this.selectedModel;
        this.selectedModel = model;
        if (oldModel != null) {
            oldModel.setSelected(false);
        }
        this.firePropertyChange(oldModel, model);
    }

    public void setDefault(ButtonModel model) {
        this.defaultModel = model;
        if (this.getSelected() == null && this.defaultModel != null) {
            this.defaultModel.setSelected(true);
        }
    }

    public void setSelected(ButtonModel model) {
        if (model == null) {
            this.selectNewModel(null);
        } else {
            model.setSelected(true);
        }
    }

    public void setSelected(ButtonModel model, boolean value) {
        if (value) {
            if (model == this.getSelected()) {
                return;
            }
            this.selectNewModel(model);
        } else {
            if (model != this.getSelected()) {
                return;
            }
            if (this.getDefault() == null) {
                return;
            }
            this.getDefault().setSelected(true);
        }
    }
}

