﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/scheduler/Scheduler_EXPORTS.h>
#include <aws/scheduler/model/ScheduleGroupState.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Scheduler {
namespace Model {
class GetScheduleGroupResult {
 public:
  AWS_SCHEDULER_API GetScheduleGroupResult() = default;
  AWS_SCHEDULER_API GetScheduleGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SCHEDULER_API GetScheduleGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the schedule group.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetScheduleGroupResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the schedule group was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  GetScheduleGroupResult& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the schedule group was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModificationDate() const { return m_lastModificationDate; }
  template <typename LastModificationDateT = Aws::Utils::DateTime>
  void SetLastModificationDate(LastModificationDateT&& value) {
    m_lastModificationDateHasBeenSet = true;
    m_lastModificationDate = std::forward<LastModificationDateT>(value);
  }
  template <typename LastModificationDateT = Aws::Utils::DateTime>
  GetScheduleGroupResult& WithLastModificationDate(LastModificationDateT&& value) {
    SetLastModificationDate(std::forward<LastModificationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schedule group.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetScheduleGroupResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the state of the schedule group.</p>
   */
  inline ScheduleGroupState GetState() const { return m_state; }
  inline void SetState(ScheduleGroupState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline GetScheduleGroupResult& WithState(ScheduleGroupState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetScheduleGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::Utils::DateTime m_creationDate{};

  Aws::Utils::DateTime m_lastModificationDate{};

  Aws::String m_name;

  ScheduleGroupState m_state{ScheduleGroupState::NOT_SET};

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
  bool m_lastModificationDateHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Scheduler
}  // namespace Aws
