/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.api.model.FlexibleSolrJerseyResponse;
import org.apache.solr.client.api.model.IndexType;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class QueryingApi {

    public static class Query
    extends SolrRequest<QueryResponse> {
        private final IndexType indexType;
        private final String indexName;
        private String q;
        private List<String> fq;
        private String fl;
        private Integer rows;

        public Query(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/select".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        public void setQ(String q) {
            this.q = q;
        }

        public void setFq(List<String> fq) {
            this.fq = fq;
        }

        public void setFl(String fl) {
            this.fl = fl;
        }

        public void setRows(Integer rows) {
            this.rows = rows;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.q != null) {
                params.add("q", this.q);
            }
            if (this.fq != null) {
                this.fq.forEach(v -> params.add("fq", (String)v));
            }
            if (this.fl != null) {
                params.add("fl", this.fl);
            }
            if (this.rows != null) {
                params.add("rows", this.rows.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("q");
            queryParams.add("fq");
            queryParams.add("fl");
            queryParams.add("rows");
            return queryParams;
        }

        @Override
        protected QueryResponse createResponse(SolrClient client) {
            return new QueryResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class QueryResponse
    extends JacksonParsingResponse<FlexibleSolrJerseyResponse> {
        public QueryResponse() {
            super(FlexibleSolrJerseyResponse.class);
        }
    }

    public static class JsonQuery
    extends SolrRequest<JsonQueryResponse> {
        private final Object requestBody;
        private final IndexType indexType;
        private final String indexName;

        public JsonQuery(IndexType indexType, String indexName, Object requestBody) {
            super(SolrRequest.METHOD.valueOf("POST"), "/{indexType}/{indexName}/select".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
            this.requestBody = requestBody;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new RequestWriter.ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    ((InputStream)requestBody).transferTo(os);
                }

                @Override
                public String getContentType() {
                    return "application/octet-stream";
                }
            };
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected JsonQueryResponse createResponse(SolrClient client) {
            return new JsonQueryResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class JsonQueryResponse
    extends JacksonParsingResponse<FlexibleSolrJerseyResponse> {
        public JsonQueryResponse() {
            super(FlexibleSolrJerseyResponse.class);
        }
    }
}

