/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.FieldType;

public abstract class BaseEditorialTransformer
extends DocTransformer {
    final String name;
    final String idFieldName;
    final FieldType ft;

    public BaseEditorialTransformer(String name, String idFieldName, FieldType ft) {
        this.name = name;
        this.idFieldName = idFieldName;
        this.ft = ft;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void transform(SolrDocument doc, int docid) {
        Set<BytesRef> ids = this.getIdSet();
        if (ids != null && !ids.isEmpty()) {
            BytesRef key = this.getKey(doc);
            doc.setField(this.name, (Object)ids.contains(key));
        } else {
            doc.setField(this.name, (Object)Boolean.FALSE);
        }
    }

    protected abstract Set<BytesRef> getIdSet();

    protected BytesRef getKey(SolrDocument doc) {
        Object obj = doc.get((Object)this.idFieldName);
        if (obj instanceof IndexableField) {
            IndexableField f = (IndexableField)obj;
            BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
            Number n = f.numericValue();
            if (n != null) {
                this.ft.readableToIndexed(n.toString(), bytesRefBuilder);
            } else {
                this.ft.readableToIndexed(f.stringValue(), bytesRefBuilder);
            }
            return bytesRefBuilder.get();
        }
        if (obj instanceof String) {
            return new BytesRef((CharSequence)((String)obj));
        }
        throw new AssertionError((Object)("Expected an IndexableField but got: " + String.valueOf(obj.getClass())));
    }
}

