/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=10)
public class PostRequestDecorationFilter
implements ContainerResponseFilter {
    public static final int PRIORITY = 10;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getPropertyNames().contains("RESOURCE_NOT_FOUND")) {
            return;
        }
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        if (!responseContext.hasEntity() || !SolrJerseyResponse.class.isInstance(responseContext.getEntity())) {
            log.debug("Skipping QTime assignment because response was not a SolrJerseyResponse");
            return;
        }
        SolrJerseyResponse response = (SolrJerseyResponse)responseContext.getEntity();
        response.responseHeader.qTime = Math.round(solrQueryRequest.getRequestTimer().getTime());
    }
}

