/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv;

public class CharBuffer {
    private char[] c;
    private int length;

    public CharBuffer() {
        this(32);
    }

    public CharBuffer(int length) {
        if (length == 0) {
            throw new IllegalArgumentException("Can't create an empty CharBuffer");
        }
        this.c = new char[length];
    }

    public void clear() {
        this.length = 0;
    }

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.c.length;
    }

    public void append(CharBuffer cb) {
        if (cb == null) {
            return;
        }
        this.provideCapacity(this.length + cb.length);
        System.arraycopy(cb.c, 0, this.c, this.length, cb.length);
        this.length += cb.length;
    }

    public void append(String s) {
        if (s == null) {
            return;
        }
        this.append(s.toCharArray());
    }

    @Deprecated
    public void append(StringBuffer sb) {
        if (sb == null) {
            return;
        }
        this.provideCapacity(this.length + sb.length());
        sb.getChars(0, sb.length(), this.c, this.length);
        this.length += sb.length();
    }

    public void append(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        this.provideCapacity(this.length + sb.length());
        sb.getChars(0, sb.length(), this.c, this.length);
        this.length += sb.length();
    }

    public void append(char[] data) {
        if (data == null) {
            return;
        }
        this.provideCapacity(this.length + data.length);
        System.arraycopy(data, 0, this.c, this.length, data.length);
        this.length += data.length;
    }

    public void append(char data) {
        this.provideCapacity(this.length + 1);
        this.c[this.length] = data;
        ++this.length;
    }

    public void shrink() {
        if (this.c.length == this.length) {
            return;
        }
        char[] newc = new char[this.length];
        System.arraycopy(this.c, 0, newc, 0, this.length);
        this.c = newc;
    }

    public void trimTrailingWhitespace() {
        while (this.length > 0 && Character.isWhitespace(this.c[this.length - 1])) {
            --this.length;
        }
    }

    public char[] getCharacters() {
        if (this.c.length == this.length) {
            return this.c;
        }
        char[] chars = new char[this.length];
        System.arraycopy(this.c, 0, chars, 0, this.length);
        return chars;
    }

    public char charAt(int pos) {
        return this.c[pos];
    }

    public String toString() {
        return new String(this.c, 0, this.length);
    }

    public void provideCapacity(int capacity) {
        if (this.c.length >= capacity) {
            return;
        }
        int newcapacity = (capacity * 3 >> 1) + 1;
        char[] newc = new char[newcapacity];
        System.arraycopy(this.c, 0, newc, 0, this.length);
        this.c = newc;
    }
}

