/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.io.IOException;
import org.apache.solr.client.api.endpoint.CollectionPropertyApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpdateCollectionPropertyRequestBody;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CollectionProperty
extends AdminAPIBase
implements CollectionPropertyApi {
    public CollectionProperty(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createOrUpdateCollectionProperty(String collName, String propName, UpdateCollectionPropertyRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CollectionProperty.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        this.modifyCollectionProperty(collName, propName, requestBody.value);
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteCollectionProperty(String collName, String propName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CollectionProperty.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        this.modifyCollectionProperty(collName, propName, null);
        return response;
    }

    private void modifyCollectionProperty(String collection, String propertyName, String propertyValue) throws IOException {
        String resolvedCollection = this.coreContainer.getAliases().resolveSimpleAlias(collection);
        CollectionProperties cp = new CollectionProperties(this.coreContainer.getZkController().getZkClient());
        cp.setCollectionProperty(resolvedCollection, propertyName, propertyValue);
    }
}

