/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.carrot2.attrs.AttrMetadata;
import org.carrot2.attrs.Constraint;

public abstract class Attr<T>
implements AttrMetadata {
    private final String label;
    private final List<? extends Constraint<? super T>> constraints;
    T value;

    public Attr(T defaultValue, String label, List<? extends Constraint<? super T>> constraints) {
        this.label = label;
        this.constraints = constraints;
        this.value = defaultValue;
    }

    @Override
    public final String getDescription() {
        return this.label;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.constraints.forEach(c -> c.accept(value));
        this.value = value;
    }

    public List<Constraint<? super T>> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    protected static class BuilderScaffold<T> {
        protected List<Constraint<? super T>> constraints = new ArrayList<Constraint<? super T>>();
        protected String label;

        protected BuilderScaffold() {
        }

        protected void addConstraint(Constraint<? super T> c) {
            this.constraints.add(c);
        }

        protected List<? extends Constraint<? super T>> getConstraint() {
            return this.constraints;
        }

        public BuilderScaffold<T> label(String label) {
            this.label = label;
            return this;
        }
    }
}

