\name{MirrorPadImageFilter}
\alias{MirrorPadImageFilter}
\title{MirrorPadImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Increase the image size by padding with replicants of the input image
value.
MirrorPadImageFilter}
\details{
MirrorPadImageFilter changes the image bounds of an image. Any added pixels are filled in
with a mirrored replica of the input image. For instance, if the
output image needs a pixel that is two pixels to the left of the
LargestPossibleRegion of the input image, the value assigned will be
from the pixel two pixels inside the left boundary of the
LargestPossibleRegion. The image bounds of the output must be
specified.
Visual explanation of padding regions.
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
Exponential decay in the bounds is enabled when DecayBase has to be in
the range (0.0, 1.0]. When it is 1.0 it is disabled. The decay rate is
based on the Manhattan distance.
See:
WrapPadImageFilter , ConstantPadImageFilter
MirrorPad for the procedural interface
itk::MirrorPadImageFilter for the Doxygen on the original ITK class.
MirrorPadImageFilter}
%C++ includes: sitkMirrorPadImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetDecayBase() const:}{
Get/Set the base for exponential decay in mirrored region.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetPadLowerBound() const:}{}
\item{std::vector< unsigned int > GetPadUpperBound() const:}{}
\item{ MirrorPadImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetDecayBase(double DecayBase):}{
Get/Set the base for exponential decay in mirrored region.
}
\item{Self SetPadLowerBound(std::vector< unsigned int > PadLowerBound):}{}
\item{Self SetPadUpperBound(std::vector< unsigned int > PadUpperBound):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MirrorPadImageFilter():}{
Destructor
}
}
}
