/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessorVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FilterQueryRequestProcessor
implements RequestProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, FilterQueryRequestProcessor> {
    @Nullable
    private final String description;
    @Nullable
    private final Boolean ignoreFailure;
    @Nullable
    private final Query query;
    @Nullable
    private final String tag;
    public static final JsonpDeserializer<FilterQueryRequestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilterQueryRequestProcessor::setupFilterQueryRequestProcessorDeserializer);

    private FilterQueryRequestProcessor(Builder builder) {
        this.description = builder.description;
        this.ignoreFailure = builder.ignoreFailure;
        this.query = builder.query;
        this.tag = builder.tag;
    }

    public static FilterQueryRequestProcessor of(Function<Builder, ObjectBuilder<FilterQueryRequestProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RequestProcessor.Kind _requestProcessorKind() {
        return RequestProcessor.Kind.FilterQuery;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFilterQueryRequestProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.query);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterQueryRequestProcessor other = (FilterQueryRequestProcessor)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.query, other.query) && Objects.equals(this.tag, other.tag);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FilterQueryRequestProcessor> {
        @Nullable
        private String description;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private Query query;
        @Nullable
        private String tag;

        public Builder() {
        }

        private Builder(FilterQueryRequestProcessor o) {
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.query = o.query;
            this.tag = o.tag;
        }

        private Builder(Builder o) {
            this.description = o.description;
            this.ignoreFailure = o.ignoreFailure;
            this.query = o.query;
            this.tag = o.tag;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Nonnull
        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Override
        @Nonnull
        public FilterQueryRequestProcessor build() {
            this._checkSingleUse();
            return new FilterQueryRequestProcessor(this);
        }
    }
}

