#include <Foundation/Foundation.h>
#include <CoreText/CoreText.h>
#include <vector>
#include <string.h>

void getAvailableFonts(std::vector<char *> &res) {
	CTFontCollectionRef collection = CTFontCollectionCreateFromAvailableFonts(NULL);

	NSArray *matches = (NSArray *) CTFontCollectionCreateMatchingFontDescriptors(collection);
	for (id m in matches) {
		CTFontDescriptorRef match = (CTFontDescriptorRef) m;
		NSString *family = (NSString *) CTFontDescriptorCopyAttribute(match, kCTFontFamilyNameAttribute);
		if (family == NULL) continue;
		char *str_family = (char *) [family UTF8String];
		char *str = new char[strlen(str_family) + 1];
		strcpy(str, str_family);
		res.push_back(str);
		[family release];
	}
	
	[matches release];
	CFRelease(collection);
}
