/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Unstable
public class PlacementSpec {
    private final int startPartition;
    private final int numPartitions;
    private final short numReplicas;

    public PlacementSpec(int startPartition, int numPartitions, short numReplicas) {
        this.startPartition = startPartition;
        this.numPartitions = numPartitions;
        this.numReplicas = numReplicas;
    }

    public int startPartition() {
        return this.startPartition;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public short numReplicas() {
        return this.numReplicas;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        PlacementSpec other = (PlacementSpec)o;
        return this.startPartition == other.startPartition && this.numPartitions == other.numPartitions && this.numReplicas == other.numReplicas;
    }

    public int hashCode() {
        return Objects.hash(this.startPartition, this.numPartitions, this.numReplicas);
    }

    public String toString() {
        return "PlacementSpec(startPartition=" + this.startPartition + ", numPartitions=" + this.numPartitions + ", numReplicas=" + this.numReplicas + ")";
    }
}

