/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.PixelGrabber;
import java.net.URL;
import net.infonode.util.Direction;
import net.infonode.util.ImageException;
import net.infonode.util.math.Int4;

public final class ImageUtils {
    public static final Image create(String filename) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(filename);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final Image create(URL url) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(url);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final Image create(byte[] data) throws ImageException {
        Image image = Toolkit.getDefaultToolkit().createImage(data);
        ImageUtils.waitImage(image);
        return image;
    }

    public static final void waitImage(Image image) throws ImageException {
        MediaTracker tracker = new MediaTracker(new Canvas());
        tracker.addImage(image, 1);
        try {
            tracker.waitForID(1);
        }
        catch (InterruptedException e) {
            throw new ImageException("Interrupted when creating image!");
        }
    }

    public static final int[] getPixels(Image image) throws ImageException {
        return ImageUtils.getPixels(image, 0, 0, image.getWidth(null), image.getHeight(null));
    }

    public static final int[] getPixels(Image image, int x, int y, int width, int height) throws ImageException {
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, x, y, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new ImageException("Interrupted waiting for pixels");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new ImageException("Image fetch aborted or errored");
        }
        return pixels;
    }

    public static final int getAlpha(int pixel) {
        return pixel >> 24 & 0xFF;
    }

    public static final int getRed(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    public static final int getGreen(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    public static final int getBlue(int pixel) {
        return pixel & 0xFF;
    }

    public static final int createPixel(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int toIntColor(Int4 i) {
        return i.getD() << 8 & 0xFF000000 | i.getA() & 0xFF0000 | i.getB() >> 8 & 0xFF00 | i.getC() >> 16 & 0xFF;
    }

    public static Int4 toInt4(Color c) {
        return new Int4(c.getRed() << 16, c.getGreen() << 16, c.getBlue() << 16, c.getAlpha() << 16);
    }

    public static Color toColor(Int4 c) {
        return new Color(c.getA() >> 16, c.getB() >> 16, c.getC() >> 16, c.getD() >> 16);
    }

    public static final int[] createGradientPixels(Color[] colors, int width, int height) {
        int[] pixels = new int[width * height];
        ImageUtils.createGradientPixels(colors, width, height, pixels);
        return pixels;
    }

    public static final int[] createGradientPixels(Color[] colors, int width, int height, int[] pixels) {
        int p = 0;
        Int4 c1 = ImageUtils.toInt4(colors[0]);
        Int4 c2 = ImageUtils.toInt4(colors[1]);
        Int4 dc1 = ImageUtils.toInt4(colors[2]).sub(ImageUtils.toInt4(colors[0])).div(height);
        Int4 dc2 = ImageUtils.toInt4(colors[3]).sub(ImageUtils.toInt4(colors[1])).div(height);
        Int4 d = new Int4();
        Int4 c = new Int4();
        int y = 0;
        while (y < height) {
            d.set(c2).sub(c1).div(width);
            c.set(c1);
            int stop = p + width;
            while (p < stop) {
                pixels[p] = ImageUtils.toIntColor(c);
                c.add(d);
                ++p;
            }
            c1.add(dc1);
            c2.add(dc2);
            ++y;
        }
        return pixels;
    }

    public static AffineTransform createTransform(Direction direction, boolean horizontalFlip, boolean verticalFlip, int width, int height) {
        int m10;
        int m01;
        int m00;
        int vf;
        int hf = horizontalFlip ? -1 : 1;
        int n = vf = verticalFlip ? -1 : 1;
        int n2 = direction == Direction.RIGHT ? hf : (m00 = direction == Direction.LEFT ? -hf : 0);
        int n3 = direction == Direction.DOWN ? -vf : (m01 = direction == Direction.UP ? vf : 0);
        int n4 = direction == Direction.DOWN ? hf : (m10 = direction == Direction.UP ? -hf : 0);
        int m11 = direction == Direction.RIGHT ? vf : (direction == Direction.LEFT ? -vf : 0);
        return new AffineTransform(m00, m10, m01, m11, m00 == -1 ? width : (m01 == -1 ? height : 0), m10 == -1 ? width : (m11 == -1 ? height : 0));
    }
}

