/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDBLink;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class OracleSynonym
extends OracleSchemaObject
implements DBSAlias {
    private String objectOwner;
    private String objectTypeName;
    private String objectName;
    private String dbLink;

    public OracleSynonym(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SYNONYM_NAME"), true);
        this.objectTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
        this.objectOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_OWNER");
        this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        this.dbLink = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DB_LINK");
    }

    public OracleObjectType getObjectType() {
        return OracleObjectType.getByType(this.objectTypeName);
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    @Property(viewable=true, order=3)
    public Object getObjectOwner() {
        OracleSchema schema = (OracleSchema)this.getDataSource().schemaCache.getCachedObject(this.objectOwner);
        return schema == null ? this.objectOwner : schema;
    }

    @Property(viewable=true, linkPossible=true, order=4)
    public Object getObject(DBRProgressMonitor monitor) throws DBException {
        if (this.objectTypeName == null) {
            return null;
        }
        return OracleObjectType.resolveObject(monitor, this.getDataSource(), this.dbLink, this.objectTypeName, this.objectOwner, this.objectName);
    }

    @Property(viewable=true, order=5)
    public Object getDbLink(DBRProgressMonitor monitor) throws DBException {
        return OracleDBLink.resolveObject(monitor, this.getSchema(), this.dbLink);
    }

    public DBSObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        Object object = this.getObject(monitor);
        if (object instanceof DBSObject) {
            return (DBSObject)object;
        }
        return null;
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        if ("PUBLIC".equals(this.getSchema().getName())) {
            return DBUtils.getQuotedIdentifier((DBSObject)this);
        }
        return super.getFullyQualifiedName(context);
    }
}

