/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view.helpers;

import bt747.j2se_view.J2SEAppController;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Hashtable;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import java.awt.FontMetrics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Formatter;
import javax.swing.JOptionPane;

public final class TaggedFilePathFactory {
    private String destTemplate = "%p" + File.separator + "%f_tagged%e";
    private String orgTemplate = "%p" + File.separator + "%f%e_original";

    public final String getTaggedFilePath$f100de5(String string) {
        return TaggedFilePathFactory.getFilePath$71d0f99b(this.destTemplate, string);
    }

    public final String getOrgFilePath$f100de5(String string) {
        return TaggedFilePathFactory.getFilePath$71d0f99b(this.orgTemplate, string);
    }

    private static String getFilePath$71d0f99b(String string, String string2) {
        String string3;
        String string4;
        int n = Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92));
        if (n >= 0) {
            string4 = string2.substring(0, n + 1);
            string2 = string2.substring(n + 1);
        } else {
            string4 = "";
        }
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            string3 = string2.substring(0, n2);
            string2 = string2.substring(n2);
        } else {
            string3 = string2;
            string2 = "";
        }
        BT747Hashtable bT747Hashtable = JavaLibBridge.getHashtableInstance(5);
        bT747Hashtable.put("p", string4);
        bT747Hashtable.put("e", string2);
        bT747Hashtable.put("f", string3);
        return Generic.expandPercentTokens(string, bT747Hashtable);
    }

    public final String getDestTemplate() {
        return this.destTemplate;
    }

    public final void setDestTemplate(String string) {
        this.destTemplate = string;
    }

    public static Class<?> getDataDisplayClass(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 35: {
                return String.class;
            }
            case 36: {
                return Integer.class;
            }
            case 37: {
                return Integer.class;
            }
            case 38: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return String.class;
            }
            case 22: {
                return Float.class;
            }
            case 20: {
                return Float.class;
            }
            case 21: {
                return Float.class;
            }
            case 29: {
                return String.class;
            }
            case 24: {
                return String.class;
            }
            case 31: {
                return Integer.class;
            }
            case 33: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 27: {
                return String.class;
            }
            case 28: {
                return String.class;
            }
            case 4: {
                break;
            }
            case 26: {
                break;
            }
            case 5: {
                return Float.class;
            }
            case 32: {
                return Float.class;
            }
            case 6: {
                return Float.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return Float.class;
            }
            case 10: {
                return Float.class;
            }
            case 11: {
                return Float.class;
            }
            case 12: {
                return Integer.class;
            }
            case 25: {
                return String.class;
            }
            case 13: {
                break;
            }
            case 34: {
                return String.class;
            }
            case 17: {
                return String.class;
            }
            case 30: {
                return String.class;
            }
            case 18: {
                return Integer.class;
            }
            case 19: {
                return Float.class;
            }
            case 23: {
                return Float.class;
            }
            case 48: 
            case 49: {
                return String.class;
            }
            case 50: {
                return Object.class;
            }
            case 51: {
                return String.class;
            }
            default: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public static String getDataDisplayName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "TAB_TITLE_None";
                break;
            }
            case 35: {
                string = "TAB_TITLE_Image_path";
                break;
            }
            case 36: {
                string = "TAB_TITLE_Width";
                break;
            }
            case 37: {
                string = "TAB_TITLE_Height";
                break;
            }
            case 38: {
                string = "TAB_TITLE_Geometry";
                break;
            }
            case 2: {
                string = "TAB_TITLE_Latitude";
                break;
            }
            case 3: {
                string = "TAB_TITLE_Longitude";
                break;
            }
            case 45: {
                string = "TAB_TITLE_File_Date_Time";
                break;
            }
            case 46: {
                string = "TAB_TITLE_File_Date";
                break;
            }
            case 47: {
                string = "TAB_TITLE_File_Time";
                break;
            }
            case 42: {
                string = "TAB_TITLE_Tag_Date_Time";
                break;
            }
            case 43: {
                string = "TAB_TITLE_Tag_Date";
                break;
            }
            case 44: {
                string = "TAB_TITLE_Tag_Time";
                break;
            }
            case 39: {
                string = "TAB_TITLE_GPS_Date_Time";
                break;
            }
            case 40: {
                string = "TAB_TITLE_GPS_Date";
                break;
            }
            case 41: {
                string = "TAB_TITLE_GPS_Time";
                break;
            }
            case 22: {
                string = "TAB_TITLE_Log_time";
                break;
            }
            case 20: {
                string = "TAB_TITLE_Log_Dist";
                break;
            }
            case 21: {
                string = "TAB_TITLE_Log_speed";
                break;
            }
            case 29: {
                string = "TAB_TITLE_NS";
                break;
            }
            case 24: {
                string = "TAB_TITLE_EW";
                break;
            }
            case 31: {
                string = "TAB_TITLE_Record_nbr";
                break;
            }
            case 33: {
                string = "TAB_TITLE_UTC_Value";
                break;
            }
            case 1: {
                string = "TAB_TITLE_Valid";
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 4: {
                string = "TAB_TITLE_Height_m";
                break;
            }
            case 26: {
                string = "TAB_TITLE_Height_ft";
                break;
            }
            case 5: {
                string = "TAB_TITLE_Speed_kmh";
                break;
            }
            case 32: {
                string = "TAB_TITLE_Speed_mph";
                break;
            }
            case 6: {
                string = "TAB_TITLE_Heading";
                break;
            }
            case 7: {
                string = "TAB_TITLE_DSTA";
                break;
            }
            case 8: {
                string = "TAB_TITLE_DAGE";
                break;
            }
            case 9: {
                string = "TAB_TITLE_PDOP";
                break;
            }
            case 10: {
                string = "TAB_TITLE_HDOP";
                break;
            }
            case 11: {
                string = "TAB_TITLE_VDOP";
                break;
            }
            case 12: {
                string = "TAB_TITLE_NSAT";
                break;
            }
            case 25: {
                string = "TAB_TITLE_Fix";
                break;
            }
            case 13: {
                string = "TAB_TITLE_SID";
                break;
            }
            case 34: {
                string = "TAB_TITLE_VOX_File";
                break;
            }
            case 17: {
                string = "TAB_TITLE_RCR";
                break;
            }
            case 30: {
                string = "TAB_TITLE_RCR_Description";
                break;
            }
            case 18: {
                string = "TAB_TITLE_MS";
                break;
            }
            case 19: {
                string = "TAB_TITLE_Distance_m";
                break;
            }
            case 23: {
                string = "TAB_TITLE_Distance_ft";
                break;
            }
            case 48: {
                string = "TAB_TITLE_StartTime";
                break;
            }
            case 49: {
                string = "TAB_TITLE_EndTime";
                break;
            }
            case 50: {
                string = "TAB_TITLE_Color";
                break;
            }
            case 51: {
                string = "TAB_TITLE_FileName";
            }
        }
        if (string != null) {
            string = J2SEAppController.getString(string);
        }
        return string;
    }

    public static int defaultDataWidth(int n, FontMetrics object) {
        FontMetrics fontMetrics = object;
        object = " ";
        switch (n) {
            case 0: {
                object = " ";
                break;
            }
            case 35: {
                object = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
                break;
            }
            case 36: {
                object = "0000";
                break;
            }
            case 37: {
                object = "0000";
                break;
            }
            case 38: {
                object = "0000x0000";
                break;
            }
            case 2: 
            case 3: {
                object = "000.00000000";
                break;
            }
            case 39: 
            case 42: 
            case 45: 
            case 48: 
            case 49: {
                object = "2000/00/00 00:00:00";
                break;
            }
            case 40: 
            case 43: 
            case 46: {
                object = "2000/00/00";
                break;
            }
            case 41: 
            case 44: 
            case 47: {
                object = "00:00:00";
                break;
            }
            case 22: {
                object = "0000";
                break;
            }
            case 20: {
                object = "TAB_TITLE_Log_Dist";
                break;
            }
            case 21: {
                object = "TAB_TITLE_Log_speed";
                break;
            }
            case 29: {
                object = "TAB_TITLE_NS";
                break;
            }
            case 24: {
                object = "TAB_TITLE_EW";
                break;
            }
            case 31: {
                object = "#######";
                break;
            }
            case 33: {
                object = "00000000";
                break;
            }
            case 1: {
                object = "#0000";
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 4: 
            case 5: 
            case 26: 
            case 32: {
                object = "-0000.00000";
                break;
            }
            case 6: {
                object = "000.0";
                break;
            }
            case 7: {
                object = "00";
                break;
            }
            case 8: {
                object = "00";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                object = "XDOP";
                break;
            }
            case 12: {
                object = "00";
                break;
            }
            case 25: {
                object = "XXXX";
                break;
            }
            case 13: {
                object = "00";
                break;
            }
            case 34: {
                object = "XXXXXXXXXXXXXXXXXXXXXXXX";
                break;
            }
            case 17: {
                object = "XXXXX";
                break;
            }
            case 30: {
                object = "XXXXXXXXXXXXXXXXXXXXXXXX";
                break;
            }
            case 18: {
                object = "000";
                break;
            }
            case 19: 
            case 23: {
                object = "000000";
                break;
            }
            case 50: {
                object = "XXXXXXXX";
                break;
            }
            case 51: {
                object = "XXXXXXXXXXXXXXXXXXXXXXXX";
            }
        }
        return fontMetrics.stringWidth((String)object);
    }

    public static Object getValue(GPSRecord gPSRecord, int n) {
        switch (n) {
            case 22: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 29: {
                break;
            }
            case 24: {
                break;
            }
            case 31: {
                if (!gPSRecord.hasRecCount()) break;
                return gPSRecord.recCount;
            }
            case 33: {
                if (!gPSRecord.hasUtc()) break;
                return (long)gPSRecord.getUtc();
            }
            case 40: {
                if (!gPSRecord.hasUtc()) break;
                return CommonOut.getDateStr(gPSRecord.getUtc());
            }
            case 41: {
                if (!gPSRecord.hasUtc()) break;
                return CommonOut.getTimeStr(gPSRecord.getUtc());
            }
            case 39: {
                if (!gPSRecord.hasUtc()) break;
                return CommonOut.getDateTimeStr(gPSRecord.getUtc());
            }
            case 43: {
                if (!gPSRecord.hasTagUtc()) break;
                return CommonOut.getDateStr(gPSRecord.tagutc);
            }
            case 44: {
                if (!gPSRecord.hasTagUtc()) break;
                return CommonOut.getTimeStr(gPSRecord.tagutc);
            }
            case 42: {
                if (!gPSRecord.hasTagUtc()) break;
                return CommonOut.getDateTimeStr(gPSRecord.tagutc);
            }
            case 1: {
                if (!gPSRecord.hasValid()) break;
                return CommonOut.getFixText(gPSRecord.getValid());
            }
            case 27: {
                if (!gPSRecord.hasLatitude()) break;
                if (gPSRecord.getLatitude() < 0.0) {
                    return -gPSRecord.getLatitude();
                }
                return gPSRecord.getLatitude();
            }
            case 28: {
                if (!gPSRecord.hasLongitude()) break;
                if (gPSRecord.getLongitude() < 0.0) {
                    return -gPSRecord.getLongitude();
                }
                return gPSRecord.getLongitude();
            }
            case 2: {
                if (!gPSRecord.hasLatitude()) break;
                return gPSRecord.getLatitude();
            }
            case 3: {
                if (!gPSRecord.hasLongitude()) break;
                return gPSRecord.getLongitude();
            }
            case 4: {
                if (!gPSRecord.hasHeight()) break;
                return Float.valueOf(gPSRecord.getHeight());
            }
            case 26: {
                break;
            }
            case 5: {
                if (!gPSRecord.hasSpeed()) break;
                return Float.valueOf(gPSRecord.getSpeed());
            }
            case 32: {
                break;
            }
            case 6: {
                if (!gPSRecord.hasHeading()) break;
                return Float.valueOf(gPSRecord.getHeading());
            }
            case 7: {
                if (!gPSRecord.hasDsta()) break;
                return gPSRecord.getDsta();
            }
            case 8: {
                if (!gPSRecord.hasDage()) break;
                return gPSRecord.getDage();
            }
            case 9: {
                if (!gPSRecord.hasPdop()) break;
                return Float.valueOf((float)gPSRecord.getPdop() / 100.0f);
            }
            case 10: {
                if (!gPSRecord.hasHdop()) break;
                return Float.valueOf((float)gPSRecord.getHdop() / 100.0f);
            }
            case 11: {
                if (!gPSRecord.hasVdop()) break;
                return Float.valueOf((float)gPSRecord.getVdop() / 100.0f);
            }
            case 12: {
                if (!gPSRecord.hasNsat()) break;
                return gPSRecord.getNsat();
            }
            case 25: {
                if (!gPSRecord.hasValid()) break;
                return CommonOut.getFixText(gPSRecord.getValid());
            }
            case 13: {
                break;
            }
            case 34: {
                if (!gPSRecord.hasVoxStr()) break;
                return gPSRecord.voxStr;
            }
            case 17: {
                if (!gPSRecord.hasRcr()) break;
                return CommonOut.getRCRstr(gPSRecord);
            }
            case 30: {
                if (!gPSRecord.hasRcr()) break;
                return CommonOut.getRcrSymbolText(gPSRecord);
            }
            case 18: {
                if (!gPSRecord.hasMillisecond()) break;
                return gPSRecord.milisecond;
            }
            case 19: {
                if (!gPSRecord.hasDistance()) break;
                return gPSRecord.distance;
            }
        }
        return null;
    }

    public static boolean setValue(Object object, GPSRecord gPSRecord, int n) {
        try {
            switch (n) {
                case 22: {
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    break;
                }
                case 29: {
                    break;
                }
                case 24: {
                    break;
                }
                case 31: {
                    gPSRecord.recCount = (Integer)object;
                    break;
                }
                case 40: {
                    break;
                }
                case 41: {
                    break;
                }
                case 1: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
                case 2: {
                    gPSRecord.latitude = (Double)object;
                    break;
                }
                case 3: {
                    gPSRecord.longitude = (Double)object;
                }
            }
            return true;
        }
        catch (Exception exception) {
            Generic.debug("setValue " + n + " " + object, exception);
            return false;
        }
    }

    public static int getLong4byte(byte[] byArray, int n, boolean bl) {
        int n2 = bl ? (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF : (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
        return n2;
    }

    public static int getShort2byte(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        }
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int addLong4byte(byte[] byArray, int n, boolean bl, int n2) {
        if (bl) {
            byArray[n] = n2 >> 24;
            byArray[n + 1] = (byte)(n2 >> 16);
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)n2;
        } else {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = n2 >> 24;
        }
        return 4;
    }

    public static int addShort2byte(byte[] byArray, int n, boolean bl, int n2) {
        if (bl) {
            byArray[n] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)n2;
        } else {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
        }
        return 2;
    }

    public static void upload(String object, String string, String string2, String string3, File file, String string4) throws IOException {
        Generic.debug("uploading " + file.getAbsolutePath() + " to openstreetmap.org");
        try {
            string2 = string2.length() == 0 ? "No description" : string2.replaceAll("\\.;&?,/", "_");
            string3 = string3.replaceAll("\\\\.;&?,/", "_");
            Object object2 = new URL("http://www.openstreetmap.org/api/0.6/gpx/create");
            Generic.debug("url: " + object2);
            object2 = (HttpURLConnection)((URL)object2).openConnection();
            ((URLConnection)object2).setConnectTimeout(15000);
            ((HttpURLConnection)object2).setRequestMethod("POST");
            ((URLConnection)object2).setDoOutput(true);
            ((URLConnection)object2).addRequestProperty("Authorization", "Basic " + TaggedFilePathFactory.encodeBase64((String)object + ":" + string));
            ((URLConnection)object2).addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
            ((URLConnection)object2).addRequestProperty("Connection", "close");
            ((URLConnection)object2).addRequestProperty("Expect", "");
            ((URLConnection)object2).connect();
            object = new DataOutputStream(new BufferedOutputStream(((URLConnection)object2).getOutputStream()));
            TaggedFilePathFactory.writeContentDispositionFile((DataOutputStream)object, "file", file);
            TaggedFilePathFactory.writeContentDisposition((DataOutputStream)object, "description", string2);
            TaggedFilePathFactory.writeContentDisposition((DataOutputStream)object, "tags", string3);
            TaggedFilePathFactory.writeContentDisposition((DataOutputStream)object, "visibility", string4);
            ((DataOutputStream)object).writeBytes("------------------------------d10f7aa230e8--\r\n");
            ((DataOutputStream)object).flush();
            int n = ((HttpURLConnection)object2).getResponseCode();
            string2 = ((HttpURLConnection)object2).getResponseMessage();
            Generic.debug("\nreturn code: " + n + " " + string2);
            if (n != 200) {
                if (((URLConnection)object2).getHeaderField("Error") != null) {
                    string2 = string2 + "\n" + ((URLConnection)object2).getHeaderField("Error");
                }
                ((HttpURLConnection)object2).disconnect();
                throw new RuntimeException(n + " " + string2);
            }
            ((FilterOutputStream)object).close();
            ((HttpURLConnection)object2).disconnect();
            Generic.debug(file.getAbsolutePath());
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
    }

    private static void writeContentDispositionFile(DataOutputStream dataOutputStream, String object, File file) throws IOException {
        int n;
        dataOutputStream.writeBytes("------------------------------d10f7aa230e8\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + (String)object + "\"; filename=\"" + file.getName() + "\"\r\n");
        dataOutputStream.writeBytes("Content-Type: application/octet-stream\r\n");
        dataOutputStream.writeBytes("\r\n");
        object = new byte[65535];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Generic.debug("Transferring data to server");
        while ((n = ((InputStream)bufferedInputStream).read((byte[])object)) >= 0) {
            dataOutputStream.write((byte[])object, 0, n);
            dataOutputStream.flush();
        }
        ((InputStream)bufferedInputStream).close();
        dataOutputStream.writeBytes("\r\n");
    }

    private static void writeContentDisposition(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        if (string2.length() != 0) {
            dataOutputStream.writeBytes("------------------------------d10f7aa230e8\r\n");
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + string + "\"\r\n");
            dataOutputStream.writeBytes("\r\n");
            Generic.debug("name:" + string + "=" + string2);
            dataOutputStream.writeBytes(string2 + "\r\n");
        }
    }

    private static String encodeBase64(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < (string.length() + 2) / 3; ++i) {
            int n = Math.min(3, string.length() - i * 3);
            String string2 = string.substring(i * 3, i * 3 + n);
            stringBuilder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(string2.charAt(0) >> 2));
            stringBuilder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt((string2.charAt(0) & 3) << 4 | (n == 1 ? 0 : (string2.charAt(1) & 0xF0) >> 4)));
            stringBuilder.append(n > 1 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt((string2.charAt(1) & 0xF) << 2 | (n == 2 ? 0 : (string2.charAt(2) & 0xC0) >> 6)) : (char)'=');
            stringBuilder.append(n > 2 ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(string2.charAt(2) & 0x3F) : (char)'=');
        }
        return stringBuilder.toString();
    }

    public static void openURL(String string) {
        String[] stringArray = System.getProperty("os.name");
        try {
            if (stringArray.startsWith("Mac OS")) {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, string);
                return;
            }
            if (stringArray.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
                return;
            }
            stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String string2 = null;
            for (int i = 0; i < 6 && string2 == null; ++i) {
                if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                string2 = stringArray[i];
            }
            if (string2 == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{string2, string});
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + exception.getLocalizedMessage());
            return;
        }
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(null, string, objectArray).toString();
    }
}

