/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.vcs.commit.CommitMessageUi;
import git4idea.commit.GitTemplateCommitMessageProviderKt;
import git4idea.repo.GitCommitTemplateListener;
import git4idea.repo.GitCommitTemplateTracker;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lgit4idea/commit/GitCommitTemplateMessageUpdater;", "Lgit4idea/repo/GitCommitTemplateListener;", "project", "Lcom/intellij/openapi/project/Project;", "commitUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;)V", "previousTemplate", "", "templateTracker", "Lgit4idea/repo/GitCommitTemplateTracker;", "getTemplateTracker", "()Lgit4idea/repo/GitCommitTemplateTracker;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "kotlin.jvm.PlatformType", "getVcsConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "notifyCommitTemplateChanged", "", "repository", "Lgit4idea/repo/GitRepository;", "disableFieldUntilTemplateLoaded", "updateCommitMessage", "intellij.vcs.git"})
final class GitCommitTemplateMessageUpdater
implements GitCommitTemplateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final CommitMessageUi commitUi;
    @Nullable
    private String previousTemplate;

    public GitCommitTemplateMessageUpdater(@NotNull Project project, @NotNull CommitMessageUi commitUi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitUi, (String)"commitUi");
        this.project = project;
        this.commitUi = commitUi;
        this.previousTemplate = GitTemplateCommitMessageProviderKt.getTemplateCommitMessage(this.project);
    }

    private final GitCommitTemplateTracker getTemplateTracker() {
        return GitCommitTemplateTracker.Companion.getInstance(this.project);
    }

    private final VcsConfiguration getVcsConfiguration() {
        return VcsConfiguration.getInstance((Project)this.project);
    }

    @Override
    public void notifyCommitTemplateChanged(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        ActionsKt.runInEdt$default(null, () -> GitCommitTemplateMessageUpdater.notifyCommitTemplateChanged$lambda$0(this), (int)1, null);
    }

    public final void disableFieldUntilTemplateLoaded() {
        if (Promises.isPending(this.getTemplateTracker().getInitPromise())) {
            this.commitUi.startLoading();
            this.getTemplateTracker().getInitPromise().onProcessed(arg_0 -> GitCommitTemplateMessageUpdater.disableFieldUntilTemplateLoaded$lambda$1(arg_0 -> GitCommitTemplateMessageUpdater.disableFieldUntilTemplateLoaded$lambda$0(this, arg_0), arg_0));
        }
    }

    private final void updateCommitMessage() {
        if (this.project.isDisposed()) {
            return;
        }
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        String templateContent = GitTemplateCommitMessageProviderKt.getTemplateCommitMessage(this.project);
        if (templateContent != null && !Intrinsics.areEqual((Object)this.previousTemplate, (Object)templateContent)) {
            this.getVcsConfiguration().saveCommitMessage(this.commitUi.getText());
            this.commitUi.setText(templateContent);
            this.previousTemplate = templateContent;
        }
    }

    private static final Unit notifyCommitTemplateChanged$lambda$0(GitCommitTemplateMessageUpdater this$0) {
        this$0.updateCommitMessage();
        return Unit.INSTANCE;
    }

    private static final Unit disableFieldUntilTemplateLoaded$lambda$0(GitCommitTemplateMessageUpdater this$0, Unit unit) {
        ActionsKt.runInEdt$default(null, () -> GitCommitTemplateMessageUpdater.disableFieldUntilTemplateLoaded$lambda$0$0(this$0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit disableFieldUntilTemplateLoaded$lambda$0$0(GitCommitTemplateMessageUpdater this$0) {
        this$0.commitUi.stopLoading();
        return Unit.INSTANCE;
    }

    private static final void disableFieldUntilTemplateLoaded$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

