/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class PreviousCompilationAccess {
    private final StringInterner interner;

    public PreviousCompilationAccess(StringInterner interner) {
        this.interner = interner;
    }

    public PreviousCompilationData readPreviousCompilationData(File source) {
        PreviousCompilationData previousCompilationData;
        KryoBackedDecoder encoder = new KryoBackedDecoder((InputStream)new FileInputStream(source));
        try {
            previousCompilationData = new PreviousCompilationData.Serializer(this.interner).read((Decoder)encoder);
        }
        catch (Throwable throwable) {
            try {
                try {
                    encoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not read previous compilation result.", e);
            }
        }
        encoder.close();
        return previousCompilationData;
    }

    public void writePreviousCompilationData(PreviousCompilationData data, File target) {
        try (KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(target));){
            new PreviousCompilationData.Serializer(this.interner).write((Encoder)encoder, data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not store compilation result", e);
        }
    }
}

