/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.editview;

import java.util.Collection;
import java.util.HashSet;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.fsview.ITypePaneListener;
import org.apache.uima.caseditor.editor.fsview.TypeCombo;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateFeatureStructureDialog
extends IconAndMessageDialog {
    private final String title;
    private Label sizeLabel;
    private Text sizeText;
    private int arraySize;
    private final TypeSystem typeSystem;
    private final Type superType;
    private boolean isArraySizeDisplayed;
    private Type selectedType;
    private Collection<Type> filterTypes;

    protected CreateFeatureStructureDialog(Shell parentShell, Type superType, TypeSystem typeSystem) {
        super(parentShell);
        this.superType = superType;
        this.typeSystem = typeSystem;
        if (!superType.isArray()) {
            this.title = "Choose type";
            this.message = "Please choose the type to create.";
        } else {
            this.title = "Array size";
            this.message = "Please enter the size of the array.";
        }
        this.filterTypes = new HashSet<Type>();
        this.filterTypes.add(typeSystem.getType("uima.cas.ArrayBase"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Byte"));
        this.filterTypes.add(typeSystem.getType("uima.cas.AnnotationBase"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Short"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Long"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Float"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Double"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Boolean"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Float"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Integer"));
        this.filterTypes.add(typeSystem.getType("uima.cas.Sofa"));
        this.filterTypes.add(typeSystem.getType("uima.cas.String"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.title);
    }

    private void enableSizeEnter(Composite parent) {
        if (!this.isArraySizeDisplayed) {
            this.sizeLabel = new Label(parent, 0);
            this.sizeLabel.setText("Size:");
            GridData sizeLabelData = new GridData();
            sizeLabelData.horizontalAlignment = 16384;
            this.sizeLabel.setLayoutData((Object)sizeLabelData);
            this.sizeText = new Text(parent, 2048);
            GridData sizeTextData = new GridData();
            sizeTextData.grabExcessHorizontalSpace = true;
            sizeTextData.horizontalAlignment = 4;
            this.sizeText.setLayoutData((Object)sizeTextData);
            this.sizeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    try {
                        CreateFeatureStructureDialog.this.arraySize = Integer.parseInt(CreateFeatureStructureDialog.this.sizeText.getText());
                    }
                    catch (NumberFormatException e) {
                        CreateFeatureStructureDialog.this.arraySize = -1;
                    }
                }
            });
            this.isArraySizeDisplayed = true;
        }
    }

    private void disableSizeEnter() {
        if (this.isArraySizeDisplayed) {
            this.sizeLabel.dispose();
            this.sizeText.dispose();
            this.isArraySizeDisplayed = false;
        }
    }

    protected Control createDialogArea(final Composite parent) {
        this.createMessageArea(parent);
        final Composite labelAndText = (Composite)super.createDialogArea(parent);
        ((GridLayout)labelAndText.getLayout()).numColumns = 1;
        GridData labelAndTextData = new GridData(1808);
        labelAndTextData.horizontalSpan = 2;
        labelAndText.setLayoutData((Object)labelAndTextData);
        if (!this.superType.isArray()) {
            Composite typePanel = new Composite(labelAndText, 0);
            GridLayout typePanelLayout = new GridLayout();
            typePanelLayout.numColumns = 2;
            typePanel.setLayout((Layout)typePanelLayout);
            Label typeLabel = new Label(typePanel, 0);
            typeLabel.setText("Type: ");
            TypeCombo typeSelection = new TypeCombo(typePanel);
            typeSelection.setInput(this.superType, this.typeSystem, this.filterTypes);
            this.selectedType = typeSelection.getType();
            GridData typeSelectionData = new GridData();
            typeSelectionData.horizontalSpan = 1;
            typeSelectionData.horizontalAlignment = 4;
            typeSelectionData.grabExcessHorizontalSpace = true;
            typeSelection.setLayoutData(typeSelectionData);
            typeSelection.addListener(new ITypePaneListener(){

                @Override
                public void typeChanged(Type newType) {
                    CreateFeatureStructureDialog.this.selectedType = newType;
                    if (newType.isArray()) {
                        CreateFeatureStructureDialog.this.enableSizeEnter(labelAndText);
                    } else {
                        CreateFeatureStructureDialog.this.disableSizeEnter();
                    }
                    parent.pack(true);
                }
            });
        }
        if (this.superType.isArray()) {
            this.enableSizeEnter(labelAndText);
        }
        return labelAndText;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Create", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Image getImage() {
        return this.getShell().getDisplay().getSystemImage(4);
    }

    int getArraySize() {
        return this.arraySize;
    }

    Type getType() {
        return this.selectedType;
    }
}

