/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssertStatement;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.LeftmostBinaryOperandNode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.TypedNode;
import com.strobel.functions.Function;

public class AssertStatementTransform
extends ContextTrackingVisitor<Void> {
    private static final IfElseStatement ASSERT_PATTERN = new IfElseStatement(-34, new Choice(new UnaryOperatorExpression(UnaryOperatorType.NOT, new Choice(new BinaryOperatorExpression(new LeftmostBinaryOperandNode(new NamedNode("assertionsDisabledCheck", new TypeReferenceExpression(-34, new SimpleType("$any$")).member("$assertionsDisabled")), BinaryOperatorType.LOGICAL_OR, true).toExpression(), BinaryOperatorType.LOGICAL_OR, new AnyNode("condition").toExpression()), new TypeReferenceExpression(-34, new SimpleType("$any$")).member("$assertionsDisabled")).toExpression()), new BinaryOperatorExpression(new LeftmostBinaryOperandNode(new UnaryOperatorExpression(UnaryOperatorType.NOT, new NamedNode("assertionsDisabledCheck", new TypeReferenceExpression(-34, new SimpleType("$any$")).member("$assertionsDisabled")).toExpression()), BinaryOperatorType.LOGICAL_AND, true).toExpression(), BinaryOperatorType.LOGICAL_AND, new AnyNode("invertedCondition").toExpression())).toExpression(), new BlockStatement(new ThrowStatement(new ObjectCreationExpression(-34, (AstType)new SimpleType("AssertionError"), new OptionalNode(new AnyNode("message")).toExpression()))));
    private static final AssignmentExpression ASSERTIONS_DISABLED_PATTERN = new AssignmentExpression(new NamedNode("$assertionsDisabled", new Choice(new IdentifierExpression(-34, "$assertionsDisabled"), new TypedNode(TypeReferenceExpression.class).toExpression().member("$assertionsDisabled"))).toExpression(), new UnaryOperatorExpression(UnaryOperatorType.NOT, new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new NamedNode("type", new ClassOfExpression(-34, new SimpleType("$any$"))).toExpression(), "desiredAssertionStatus", new AstType[0]), new Expression[0])));

    public AssertStatementTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitIfElseStatement(IfElseStatement node, Void data) {
        super.visitIfElseStatement(node, data);
        this.transformAssert(node);
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
        super.visitAssignmentExpression(node, data);
        this.removeAssertionsDisabledAssignment(node);
        return null;
    }

    private void removeAssertionsDisabledAssignment(AssignmentExpression node) {
        if (this.context.getSettings().getShowSyntheticMembers()) {
            return;
        }
        Match m = ASSERTIONS_DISABLED_PATTERN.match(node);
        if (!m.success()) {
            return;
        }
        AstNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement && parent.getParent() instanceof BlockStatement && parent.getParent().getParent() instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration staticInitializer = (MethodDeclaration)parent.getParent().getParent();
        MethodDefinition methodDefinition = staticInitializer.getUserData(Keys.METHOD_DEFINITION);
        if (methodDefinition == null || !methodDefinition.isTypeInitializer()) {
            return;
        }
        Expression field = (Expression)CollectionUtilities.first(m.get("$assertionsDisabled"));
        ClassOfExpression type = (ClassOfExpression)m.get("type").iterator().next();
        MemberReference reference = field.getUserData(Keys.MEMBER_REFERENCE);
        if (!(reference instanceof FieldReference)) {
            return;
        }
        FieldDefinition resolvedField = ((FieldReference)reference).resolve();
        if (resolvedField == null || !resolvedField.isSynthetic()) {
            return;
        }
        TypeReference typeReference = type.getType().getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null && (MetadataResolver.areEquivalent(this.context.getCurrentType(), typeReference) || MetadataHelper.isEnclosedBy(this.context.getCurrentType(), typeReference))) {
            parent.remove();
            if (staticInitializer.getBody().getStatements().isEmpty()) {
                staticInitializer.remove();
            }
        }
    }

    private AssertStatement transformAssert(IfElseStatement ifElse) {
        Match m = ASSERT_PATTERN.match(ifElse);
        if (!m.success()) {
            return null;
        }
        Expression assertionsDisabledCheck = (Expression)CollectionUtilities.firstOrDefault(m.get("assertionsDisabledCheck"));
        Expression condition = (Expression)CollectionUtilities.firstOrDefault(m.get("condition"));
        if (condition == null && (condition = (Expression)CollectionUtilities.firstOrDefault(m.get("invertedCondition"))) != null) {
            condition = condition.replaceWith(new Function<AstNode, Expression>(){

                public Expression apply(AstNode input) {
                    return new UnaryOperatorExpression(UnaryOperatorType.NOT, (Expression)input);
                }
            });
        }
        if (condition != null && assertionsDisabledCheck != null && assertionsDisabledCheck.getParent() instanceof BinaryOperatorExpression && assertionsDisabledCheck.getParent().getParent() instanceof BinaryOperatorExpression) {
            BinaryOperatorExpression logicalOr = (BinaryOperatorExpression)assertionsDisabledCheck.getParent();
            Expression right = logicalOr.getRight();
            right.remove();
            assertionsDisabledCheck.replaceWith(right);
            condition.remove();
            logicalOr.setRight(condition);
            condition = logicalOr;
        }
        AssertStatement assertStatement = new AssertStatement(condition == null ? ifElse.getOffset() : condition.getOffset());
        if (condition != null) {
            condition.remove();
            assertStatement.setCondition(condition);
        } else {
            assertStatement.setCondition(new PrimitiveExpression(-34, false));
        }
        if (m.has("message")) {
            Expression message = (Expression)CollectionUtilities.firstOrDefault(m.get("message"));
            while (message instanceof CastExpression) {
                message = ((CastExpression)message).getExpression();
            }
            message.remove();
            assertStatement.setMessage(message);
        }
        ifElse.replaceWith(assertStatement);
        return assertStatement;
    }
}

