/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;

public final class ParameterDefinitionCollection
extends Collection<ParameterDefinition> {
    final IMethodSignature signature;
    private TypeReference _declaringType;

    ParameterDefinitionCollection(IMethodSignature signature) {
        this.signature = signature;
    }

    public final TypeReference getDeclaringType() {
        return this._declaringType;
    }

    final void setDeclaringType(TypeReference declaringType) {
        this._declaringType = declaringType;
        for (int i = 0; i < this.size(); ++i) {
            ((ParameterDefinition)this.get(i)).setDeclaringType(declaringType);
        }
    }

    @Override
    protected void afterAdd(int index, ParameterDefinition p, boolean appended) {
        p.setMethod(this.signature);
        p.setPosition(index);
        p.setDeclaringType(this._declaringType);
        if (!appended) {
            for (int i = index + 1; i < this.size(); ++i) {
                ((ParameterDefinition)this.get(i)).setPosition(i + 1);
            }
        }
        this.signature.invalidateSignature();
    }

    @Override
    protected void beforeSet(int index, ParameterDefinition p) {
        ParameterDefinition current = (ParameterDefinition)this.get(index);
        current.setMethod(null);
        current.setPosition(-1);
        current.setDeclaringType(null);
        p.setMethod(this.signature);
        p.setPosition(index);
        p.setDeclaringType(this._declaringType);
        this.signature.invalidateSignature();
    }

    @Override
    protected void afterRemove(int index, ParameterDefinition p) {
        p.setMethod(null);
        p.setPosition(-1);
        p.setDeclaringType(null);
        for (int i = index; i < this.size(); ++i) {
            ((ParameterDefinition)this.get(i)).setPosition(i);
        }
        this.signature.invalidateSignature();
    }

    @Override
    protected void beforeClear() {
        for (int i = 0; i < this.size(); ++i) {
            ((ParameterDefinition)this.get(i)).setMethod(null);
            ((ParameterDefinition)this.get(i)).setPosition(-1);
            ((ParameterDefinition)this.get(i)).setDeclaringType(null);
        }
        this.signature.invalidateSignature();
    }
}

