/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.CompositeCollection;

final class CompositeSet<E>
extends CompositeCollection<E>
implements Set<E> {
    CompositeSet(Set<E> first, Set<E> second) {
        super(first, second);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Set) {
            Set otherSet = (Set)other;
            if (this.size() == otherSet.size()) {
                try {
                    return this.containsAll(otherSet);
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Object obj : this) {
            if (obj == null) continue;
            hashCode += obj.hashCode();
        }
        return hashCode;
    }
}

