/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class Diagnostics {
    private static final String PACKAGE = "org.apache.tomcat.util";
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private static final String INDENT1 = "  ";
    private static final String INDENT2 = "\t";
    private static final String INDENT3 = "   ";
    private static final String CRLF = "\r\n";
    private static final String vminfoSystemProperty = "java.vm.info";
    private static final Log log = LogFactory.getLog(Diagnostics.class);
    private static final SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private static final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final PlatformLoggingMXBean loggingMXBean = ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class);
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final List<MemoryManagerMXBean> memoryManagerMXBeans = ManagementFactory.getMemoryManagerMXBeans();
    private static final List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();

    public static boolean isThreadContentionMonitoringEnabled() {
        return threadMXBean.isThreadContentionMonitoringEnabled();
    }

    public static void setThreadContentionMonitoringEnabled(boolean enable) {
        threadMXBean.setThreadContentionMonitoringEnabled(enable);
        boolean checkValue = threadMXBean.isThreadContentionMonitoringEnabled();
        if (enable != checkValue) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "threadContentionMonitoringEnabled", enable, checkValue));
        }
    }

    public static boolean isThreadCpuTimeEnabled() {
        return threadMXBean.isThreadCpuTimeEnabled();
    }

    public static void setThreadCpuTimeEnabled(boolean enable) {
        threadMXBean.setThreadCpuTimeEnabled(enable);
        boolean checkValue = threadMXBean.isThreadCpuTimeEnabled();
        if (enable != checkValue) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "threadCpuTimeEnabled", enable, checkValue));
        }
    }

    public static void resetPeakThreadCount() {
        threadMXBean.resetPeakThreadCount();
    }

    public static void setVerboseClassLoading(boolean verbose) {
        classLoadingMXBean.setVerbose(verbose);
        boolean checkValue = classLoadingMXBean.isVerbose();
        if (verbose != checkValue) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "verboseClassLoading", verbose, checkValue));
        }
    }

    public static void setLoggerLevel(String loggerName, String levelName) {
        loggingMXBean.setLoggerLevel(loggerName, levelName);
        String checkValue = loggingMXBean.getLoggerLevel(loggerName);
        if (!checkValue.equals(levelName)) {
            String propertyName = "loggerLevel[" + loggerName + "]";
            log.error((Object)sm.getString("diagnostics.setPropertyFail", propertyName, levelName, checkValue));
        }
    }

    public static void setVerboseGarbageCollection(boolean verbose) {
        memoryMXBean.setVerbose(verbose);
        boolean checkValue = memoryMXBean.isVerbose();
        if (verbose != checkValue) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "verboseGarbageCollection", verbose, checkValue));
        }
    }

    public static void gc() {
        memoryMXBean.gc();
    }

    public static void resetPeakUsage(String name) {
        for (MemoryPoolMXBean mbean : memoryPoolMXBeans) {
            if (!name.equals("all") && !name.equals(mbean.getName())) continue;
            mbean.resetPeakUsage();
        }
    }

    public static boolean setUsageThreshold(String name, long threshold) {
        for (MemoryPoolMXBean mbean : memoryPoolMXBeans) {
            if (!name.equals(mbean.getName())) continue;
            try {
                mbean.setUsageThreshold(threshold);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static boolean setCollectionUsageThreshold(String name, long threshold) {
        for (MemoryPoolMXBean mbean : memoryPoolMXBeans) {
            if (!name.equals(mbean.getName())) continue;
            try {
                mbean.setCollectionUsageThreshold(threshold);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                return false;
            }
        }
        return false;
    }

    private static String getThreadDumpHeader(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(ti.getThreadName()).append("\"");
        sb.append(" Id=").append(ti.getThreadId());
        sb.append(" cpu=").append(threadMXBean.getThreadCpuTime(ti.getThreadId())).append(" ns");
        sb.append(" usr=").append(threadMXBean.getThreadUserTime(ti.getThreadId())).append(" ns");
        sb.append(" blocked ").append(ti.getBlockedCount()).append(" for ").append(ti.getBlockedTime()).append(" ms");
        sb.append(" waited ").append(ti.getWaitedCount()).append(" for ").append(ti.getWaitedTime()).append(" ms");
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        sb.append(CRLF);
        sb.append("   java.lang.Thread.State: ").append((Object)ti.getThreadState());
        sb.append(CRLF);
        return sb.toString();
    }

    private static String getThreadDump(ThreadInfo ti) {
        MonitorInfo[] mis;
        StringBuilder sb = new StringBuilder(Diagnostics.getThreadDumpHeader(ti));
        for (LockInfo li : ti.getLockedSynchronizers()) {
            sb.append("\tlocks ").append(li.toString()).append(CRLF);
        }
        boolean start = true;
        StackTraceElement[] stes = ti.getStackTrace();
        Object[] monitorDepths = new Object[stes.length];
        for (MonitorInfo monitorInfo : mis = ti.getLockedMonitors()) {
            monitorDepths[monitorInfo.getLockedStackDepth()] = monitorInfo;
        }
        for (int i = 0; i < stes.length; ++i) {
            StackTraceElement ste = stes[i];
            sb.append("\tat ").append(ste.toString()).append(CRLF);
            if (start) {
                if (ti.getLockName() != null) {
                    sb.append("\t- waiting on (a ").append(ti.getLockName()).append(")");
                    if (ti.getLockOwnerName() != null) {
                        sb.append(" owned by ").append(ti.getLockOwnerName()).append(" Id=").append(ti.getLockOwnerId());
                    }
                    sb.append(CRLF);
                }
                start = false;
            }
            if (monitorDepths[i] == null) continue;
            MonitorInfo mi = (MonitorInfo)monitorDepths[i];
            sb.append("\t- locked (a ").append(mi.toString()).append(")").append(" index ");
            sb.append(mi.getLockedStackDepth()).append(" frame ").append(mi.getLockedStackFrame().toString());
            sb.append(CRLF);
        }
        return sb.toString();
    }

    private static String getThreadDump(ThreadInfo[] tinfos) {
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo tinfo : tinfos) {
            sb.append(Diagnostics.getThreadDump(tinfo));
            sb.append(CRLF);
        }
        return sb.toString();
    }

    public static String findDeadlock() {
        ThreadInfo[] tinfos;
        long[] ids = threadMXBean.findDeadlockedThreads();
        if (ids != null && (tinfos = threadMXBean.getThreadInfo(threadMXBean.findDeadlockedThreads(), true, true)) != null) {
            return sm.getString("diagnostics.deadlockFound") + CRLF + Diagnostics.getThreadDump(tinfos);
        }
        return "";
    }

    public static String getThreadDump() {
        return Diagnostics.getThreadDump(sm);
    }

    public static String getThreadDump(Enumeration<Locale> requestedLocales) {
        return Diagnostics.getThreadDump(StringManager.getManager(PACKAGE, requestedLocales));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThreadDump(StringManager requestedSm) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat simpleDateFormat = timeformat;
        synchronized (simpleDateFormat) {
            sb.append(timeformat.format(new Date()));
        }
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.threadDumpTitle"));
        sb.append(' ');
        sb.append(runtimeMXBean.getVmName());
        sb.append(" (");
        sb.append(runtimeMXBean.getVmVersion());
        String vminfo = System.getProperty(vminfoSystemProperty);
        if (vminfo != null) {
            sb.append(" ").append(vminfo);
        }
        sb.append("):\r\n");
        sb.append(CRLF);
        ThreadInfo[] tis = threadMXBean.dumpAllThreads(true, true);
        sb.append(Diagnostics.getThreadDump(tis));
        sb.append(Diagnostics.findDeadlock());
        return sb.toString();
    }

    private static String formatMemoryUsage(String name, MemoryUsage usage) {
        if (usage != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(INDENT1).append(name).append(" init: ").append(usage.getInit()).append(CRLF);
            sb.append(INDENT1).append(name).append(" used: ").append(usage.getUsed()).append(CRLF);
            sb.append(INDENT1).append(name).append(" committed: ").append(usage.getCommitted()).append(CRLF);
            sb.append(INDENT1).append(name).append(" max: ").append(usage.getMax()).append(CRLF);
            return sb.toString();
        }
        return "";
    }

    public static String getVMInfo() {
        return Diagnostics.getVMInfo(sm);
    }

    public static String getVMInfo(Enumeration<Locale> requestedLocales) {
        return Diagnostics.getVMInfo(StringManager.getManager(PACKAGE, requestedLocales));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVMInfo(StringManager requestedSm) {
        Object names;
        StringBuilder sb = new StringBuilder();
        Iterator<PlatformManagedObject> iterator = timeformat;
        synchronized (iterator) {
            sb.append(timeformat.format(new Date()));
        }
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoRuntime"));
        sb.append(":\r\n");
        sb.append("  vmName: ").append(runtimeMXBean.getVmName()).append(CRLF);
        sb.append("  vmVersion: ").append(runtimeMXBean.getVmVersion()).append(CRLF);
        sb.append("  vmVendor: ").append(runtimeMXBean.getVmVendor()).append(CRLF);
        sb.append("  specName: ").append(runtimeMXBean.getSpecName()).append(CRLF);
        sb.append("  specVersion: ").append(runtimeMXBean.getSpecVersion()).append(CRLF);
        sb.append("  specVendor: ").append(runtimeMXBean.getSpecVendor()).append(CRLF);
        sb.append("  managementSpecVersion: ").append(runtimeMXBean.getManagementSpecVersion()).append(CRLF);
        sb.append("  name: ").append(runtimeMXBean.getName()).append(CRLF);
        sb.append("  startTime: ").append(runtimeMXBean.getStartTime()).append(CRLF);
        sb.append("  uptime: ").append(runtimeMXBean.getUptime()).append(CRLF);
        sb.append("  isBootClassPathSupported: ").append(runtimeMXBean.isBootClassPathSupported()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoOs"));
        sb.append(":\r\n");
        sb.append("  name: ").append(operatingSystemMXBean.getName()).append(CRLF);
        sb.append("  version: ").append(operatingSystemMXBean.getVersion()).append(CRLF);
        sb.append("  architecture: ").append(operatingSystemMXBean.getArch()).append(CRLF);
        sb.append("  availableProcessors: ").append(operatingSystemMXBean.getAvailableProcessors()).append(CRLF);
        sb.append("  systemLoadAverage: ").append(operatingSystemMXBean.getSystemLoadAverage()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoThreadMxBean"));
        sb.append(":\r\n");
        sb.append("  isCurrentThreadCpuTimeSupported: ").append(threadMXBean.isCurrentThreadCpuTimeSupported()).append(CRLF);
        sb.append("  isThreadCpuTimeSupported: ").append(threadMXBean.isThreadCpuTimeSupported()).append(CRLF);
        sb.append("  isThreadCpuTimeEnabled: ").append(threadMXBean.isThreadCpuTimeEnabled()).append(CRLF);
        sb.append("  isObjectMonitorUsageSupported: ").append(threadMXBean.isObjectMonitorUsageSupported()).append(CRLF);
        sb.append("  isSynchronizerUsageSupported: ").append(threadMXBean.isSynchronizerUsageSupported()).append(CRLF);
        sb.append("  isThreadContentionMonitoringSupported: ").append(threadMXBean.isThreadContentionMonitoringSupported()).append(CRLF);
        sb.append("  isThreadContentionMonitoringEnabled: ").append(threadMXBean.isThreadContentionMonitoringEnabled()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoThreadCounts"));
        sb.append(":\r\n");
        sb.append("  daemon: ").append(threadMXBean.getDaemonThreadCount()).append(CRLF);
        sb.append("  total: ").append(threadMXBean.getThreadCount()).append(CRLF);
        sb.append("  peak: ").append(threadMXBean.getPeakThreadCount()).append(CRLF);
        sb.append("  totalStarted: ").append(threadMXBean.getTotalStartedThreadCount()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoStartup"));
        sb.append(":\r\n");
        for (String string : runtimeMXBean.getInputArguments()) {
            sb.append(INDENT1).append(string).append(CRLF);
        }
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoPath"));
        sb.append(":\r\n");
        if (runtimeMXBean.isBootClassPathSupported()) {
            sb.append("  bootClassPath: ").append(runtimeMXBean.getBootClassPath()).append(CRLF);
        }
        sb.append("  classPath: ").append(runtimeMXBean.getClassPath()).append(CRLF);
        sb.append("  libraryPath: ").append(runtimeMXBean.getLibraryPath()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoClassLoading"));
        sb.append(":\r\n");
        sb.append("  loaded: ").append(classLoadingMXBean.getLoadedClassCount()).append(CRLF);
        sb.append("  unloaded: ").append(classLoadingMXBean.getUnloadedClassCount()).append(CRLF);
        sb.append("  totalLoaded: ").append(classLoadingMXBean.getTotalLoadedClassCount()).append(CRLF);
        sb.append("  isVerbose: ").append(classLoadingMXBean.isVerbose()).append(CRLF);
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoClassCompilation"));
        sb.append(":\r\n");
        sb.append("  name: ").append(compilationMXBean.getName()).append(CRLF);
        sb.append("  totalCompilationTime: ").append(compilationMXBean.getTotalCompilationTime()).append(CRLF);
        sb.append("  isCompilationTimeMonitoringSupported: ").append(compilationMXBean.isCompilationTimeMonitoringSupported()).append(CRLF);
        sb.append(CRLF);
        for (MemoryManagerMXBean memoryManagerMXBean : memoryManagerMXBeans) {
            sb.append(requestedSm.getString("diagnostics.vmInfoMemoryManagers", memoryManagerMXBean.getName()));
            sb.append(":\r\n");
            sb.append("  isValid: ").append(memoryManagerMXBean.isValid()).append(CRLF);
            sb.append("  mbean.getMemoryPoolNames: \r\n");
            names = memoryManagerMXBean.getMemoryPoolNames();
            Arrays.sort((Object[])names);
            for (Object name : names) {
                sb.append(INDENT2).append((String)name).append(CRLF);
            }
            sb.append(CRLF);
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
            sb.append(requestedSm.getString("diagnostics.vmInfoGarbageCollectors", garbageCollectorMXBean.getName()));
            sb.append(":\r\n");
            sb.append("  isValid: ").append(garbageCollectorMXBean.isValid()).append(CRLF);
            sb.append("  mbean.getMemoryPoolNames: \r\n");
            names = garbageCollectorMXBean.getMemoryPoolNames();
            Arrays.sort((Object[])names);
            for (Object name : names) {
                sb.append(INDENT2).append((String)name).append(CRLF);
            }
            sb.append("  getCollectionCount: ").append(garbageCollectorMXBean.getCollectionCount()).append(CRLF);
            sb.append("  getCollectionTime: ").append(garbageCollectorMXBean.getCollectionTime()).append(CRLF);
            sb.append(CRLF);
        }
        sb.append(requestedSm.getString("diagnostics.vmInfoMemory"));
        sb.append(":\r\n");
        sb.append("  isVerbose: ").append(memoryMXBean.isVerbose()).append(CRLF);
        sb.append("  getObjectPendingFinalizationCount: ").append(memoryMXBean.getObjectPendingFinalizationCount()).append(CRLF);
        sb.append(Diagnostics.formatMemoryUsage("heap", memoryMXBean.getHeapMemoryUsage()));
        sb.append(Diagnostics.formatMemoryUsage("non-heap", memoryMXBean.getNonHeapMemoryUsage()));
        sb.append(CRLF);
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            sb.append(requestedSm.getString("diagnostics.vmInfoMemoryPools", memoryPoolMXBean.getName()));
            sb.append(":\r\n");
            sb.append("  isValid: ").append(memoryPoolMXBean.isValid()).append(CRLF);
            sb.append("  getType: ").append((Object)memoryPoolMXBean.getType()).append(CRLF);
            sb.append("  mbean.getMemoryManagerNames: \r\n");
            names = memoryPoolMXBean.getMemoryManagerNames();
            Arrays.sort((Object[])names);
            for (Object name : names) {
                sb.append(INDENT2).append((String)name).append(CRLF);
            }
            sb.append("  isUsageThresholdSupported: ").append(memoryPoolMXBean.isUsageThresholdSupported()).append(CRLF);
            try {
                sb.append("  isUsageThresholdExceeded: ").append(memoryPoolMXBean.isUsageThresholdExceeded()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            sb.append("  isCollectionUsageThresholdSupported: ").append(memoryPoolMXBean.isCollectionUsageThresholdSupported()).append(CRLF);
            try {
                sb.append("  isCollectionUsageThresholdExceeded: ").append(memoryPoolMXBean.isCollectionUsageThresholdExceeded()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                sb.append("  getUsageThreshold: ").append(memoryPoolMXBean.getUsageThreshold()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                sb.append("  getUsageThresholdCount: ").append(memoryPoolMXBean.getUsageThresholdCount()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                sb.append("  getCollectionUsageThreshold: ").append(memoryPoolMXBean.getCollectionUsageThreshold()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                sb.append("  getCollectionUsageThresholdCount: ").append(memoryPoolMXBean.getCollectionUsageThresholdCount()).append(CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            sb.append(Diagnostics.formatMemoryUsage("current", memoryPoolMXBean.getUsage()));
            sb.append(Diagnostics.formatMemoryUsage("collection", memoryPoolMXBean.getCollectionUsage()));
            sb.append(Diagnostics.formatMemoryUsage("peak", memoryPoolMXBean.getPeakUsage()));
            sb.append(CRLF);
        }
        sb.append(requestedSm.getString("diagnostics.vmInfoSystem"));
        sb.append(":\r\n");
        Map<String, String> props = runtimeMXBean.getSystemProperties();
        ArrayList<String> arrayList = new ArrayList<String>(props.keySet());
        Collections.sort(arrayList);
        for (String prop : arrayList) {
            sb.append(INDENT1).append(prop).append(": ").append(props.get(prop)).append(CRLF);
        }
        sb.append(CRLF);
        sb.append(requestedSm.getString("diagnostics.vmInfoLogger"));
        sb.append(":\r\n");
        List<String> loggers = loggingMXBean.getLoggerNames();
        Collections.sort(loggers);
        for (String logger : loggers) {
            sb.append(INDENT1).append(logger).append(": level=").append(loggingMXBean.getLoggerLevel(logger));
            sb.append(", parent=").append(loggingMXBean.getParentLoggerName(logger)).append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

