/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.CheckedArrayList;

final class MultiValuedAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = 5089428248556035466L;
    private CheckedArrayList<AbstractFeature> values;

    public MultiValuedAssociation(DefaultAssociationRole role) {
        super(role);
        this.values = new CheckedArrayList<AbstractFeature>(AbstractFeature.class);
    }

    MultiValuedAssociation(DefaultAssociationRole role, Object values) {
        super(role);
        this.values = values == null ? new CheckedArrayList<AbstractFeature>(AbstractFeature.class) : CheckedArrayList.castOrCopy((CheckedArrayList)values, AbstractFeature.class);
    }

    @Override
    public AbstractFeature getValue() {
        switch (this.values.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (AbstractFeature)this.values.get(0);
            }
        }
        throw new IllegalStateException(Resources.format((short)53, this.getName()));
    }

    @Override
    public Collection<AbstractFeature> getValues() {
        return this.values;
    }

    @Override
    public void setValue(AbstractFeature value) {
        this.values.clear();
        if (value != null) {
            this.ensureValid(this.role.getValueType(), value.getType());
            this.values.add(value);
        }
    }

    @Override
    public void setValues(Collection<? extends AbstractFeature> newValues) {
        if (newValues != this.values) {
            ArgumentChecks.ensureNonNull("values", newValues);
            DefaultFeatureType base = this.role.getValueType();
            this.values.clear();
            for (AbstractFeature abstractFeature : newValues) {
                this.ensureValid(base, abstractFeature.getType());
                this.values.add(abstractFeature);
            }
        }
    }

    @Override
    public MultiValuedAssociation clone() throws CloneNotSupportedException {
        MultiValuedAssociation clone = (MultiValuedAssociation)super.clone();
        clone.values = (CheckedArrayList)clone.values.clone();
        return clone;
    }

    public int hashCode() {
        return this.role.hashCode() + this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiValuedAssociation) {
            MultiValuedAssociation that = (MultiValuedAssociation)obj;
            return this.role.equals(that.role) && this.values.equals(that.values);
        }
        return false;
    }
}

