/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;

public class JPAAnyTypeClassDAO
extends AbstractDAO<AnyTypeClass>
implements AnyTypeClassDAO {
    protected final AnyTypeDAO anyTypeDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final GroupDAO groupDAO;
    protected final ExternalResourceDAO resourceDAO;

    public JPAAnyTypeClassDAO(AnyTypeDAO anyTypeDAO, PlainSchemaDAO plainSchemaDAO, DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, GroupDAO groupDAO, ExternalResourceDAO resourceDAO) {
        this.anyTypeDAO = anyTypeDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.groupDAO = groupDAO;
        this.resourceDAO = resourceDAO;
    }

    public AnyTypeClass find(String key) {
        return (AnyTypeClass)this.entityManager().find(JPAAnyTypeClass.class, (Object)key);
    }

    public List<AnyTypeClass> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAnyTypeClass.class.getSimpleName() + " e ", AnyTypeClass.class);
        return query.getResultList();
    }

    public AnyTypeClass save(AnyTypeClass anyTypeClass) {
        AnyTypeClass merge = (AnyTypeClass)this.entityManager().merge((Object)anyTypeClass);
        for (PlainSchema schema : merge.getPlainSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        for (PlainSchema schema : merge.getDerSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        for (PlainSchema schema : merge.getVirSchemas()) {
            schema.setAnyTypeClass(merge);
        }
        return merge;
    }

    public void delete(String key) {
        AnyTypeClass anyTypeClass = this.find(key);
        if (anyTypeClass == null) {
            return;
        }
        for (PlainSchema schema : this.plainSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (PlainSchema schema : this.derSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (PlainSchema schema : this.virSchemaDAO.findByAnyTypeClasses(List.of(anyTypeClass))) {
            schema.setAnyTypeClass(null);
        }
        for (AnyType type : this.anyTypeDAO.findByTypeClass(anyTypeClass)) {
            type.getClasses().remove(anyTypeClass);
        }
        for (TypeExtension typeExt : this.groupDAO.findTypeExtensions(anyTypeClass)) {
            typeExt.getAuxClasses().remove(anyTypeClass);
            if (!typeExt.getAuxClasses().isEmpty()) continue;
            typeExt.getGroup().getTypeExtensions().remove(typeExt);
            typeExt.setGroup(null);
        }
        for (Provision provision : this.resourceDAO.findProvisionsByAuxClass(anyTypeClass)) {
            provision.getAuxClasses().remove(anyTypeClass.getKey());
        }
        this.entityManager().remove((Object)anyTypeClass);
    }
}

