/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import liquibase.change.Change;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtil;

public class ChangedForeignKeyChangeGenerator
extends AbstractChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (ForeignKey.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Index.class, UniqueConstraint.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        ForeignKey fk2 = (ForeignKey)changedObject;
        StringUtil.StringUtilFormatter<Column> formatter = new StringUtil.StringUtilFormatter<Column>(){

            @Override
            public String toString(Column obj) {
                return obj.toString(false);
            }
        };
        DropForeignKeyConstraintChange dropFkChange = new DropForeignKeyConstraintChange();
        dropFkChange.setConstraintName(fk2.getName());
        dropFkChange.setBaseTableName(fk2.getForeignKeyTable().getName());
        AddForeignKeyConstraintChange addFkChange = new AddForeignKeyConstraintChange();
        addFkChange.setConstraintName(fk2.getName());
        addFkChange.setBaseTableName(fk2.getForeignKeyTable().getName());
        addFkChange.setBaseColumnNames(StringUtil.join(fk2.getForeignKeyColumns(), ",", (StringUtil.StringUtilFormatter)formatter));
        addFkChange.setReferencedTableName(fk2.getPrimaryKeyTable().getName());
        addFkChange.setReferencedColumnNames(StringUtil.join(fk2.getPrimaryKeyColumns(), ",", (StringUtil.StringUtilFormatter)formatter));
        addFkChange.setOnDelete(fk2.getDeleteRule());
        addFkChange.setOnUpdate(fk2.getUpdateRule());
        if (control.getIncludeCatalog()) {
            dropFkChange.setBaseTableCatalogName(fk2.getForeignKeyTable().getSchema().getCatalogName());
            addFkChange.setBaseTableCatalogName(fk2.getForeignKeyTable().getSchema().getCatalogName());
            addFkChange.setReferencedTableCatalogName(fk2.getPrimaryKeyTable().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            dropFkChange.setBaseTableSchemaName(fk2.getForeignKeyTable().getSchema().getName());
            addFkChange.setBaseTableSchemaName(fk2.getForeignKeyTable().getSchema().getName());
            addFkChange.setReferencedTableSchemaName(fk2.getPrimaryKeyTable().getSchema().getName());
        }
        if (fk2.getBackingIndex() != null) {
            control.setAlreadyHandledChanged(fk2.getBackingIndex());
        }
        return new Change[]{dropFkChange, addFkChange};
    }
}

