/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CompareRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -562642367801440060L;
    @NotNull
    private final ASN1OctetString assertionValue;
    @NotNull
    private final String attributeName;
    @NotNull
    private final String dn;

    public CompareRequestProtocolOp(@NotNull String dn, @NotNull String attributeName, @NotNull ASN1OctetString assertionValue) {
        this.dn = dn;
        this.attributeName = attributeName;
        this.assertionValue = assertionValue;
    }

    public CompareRequestProtocolOp(@NotNull CompareRequest request) {
        this.dn = request.getDN();
        this.attributeName = request.getAttributeName();
        this.assertionValue = request.getRawAssertionValue();
    }

    CompareRequestProtocolOp(@NotNull ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            reader.beginSequence();
            this.attributeName = reader.readString();
            this.assertionValue = new ASN1OctetString(reader.readBytes());
            Validator.ensureNotNull(this.dn, this.attributeName, this.assertionValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getDN() {
        return this.dn;
    }

    @NotNull
    public String getAttributeName() {
        return this.attributeName;
    }

    @NotNull
    public ASN1OctetString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public byte getProtocolOpType() {
        return 110;
    }

    @Override
    @NotNull
    public ASN1Element encodeProtocolOp() {
        return new ASN1Sequence(110, new ASN1OctetString(this.dn), new ASN1Sequence(new ASN1OctetString(this.attributeName), this.assertionValue));
    }

    @NotNull
    public static CompareRequestProtocolOp decodeProtocolOp(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] avaElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
            String attributeName = ASN1OctetString.decodeAsOctetString(avaElements[0]).stringValue();
            ASN1OctetString assertionValue = ASN1OctetString.decodeAsOctetString(avaElements[1]);
            return new CompareRequestProtocolOp(dn, attributeName, assertionValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_COMPARE_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(@NotNull ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)110);
        buffer.addOctetString(this.dn);
        ASN1BufferSequence avaSequence = buffer.beginSequence();
        buffer.addOctetString(this.attributeName);
        buffer.addElement(this.assertionValue);
        avaSequence.end();
        opSequence.end();
    }

    @NotNull
    public CompareRequest toCompareRequest(Control ... controls) {
        return new CompareRequest(this.dn, this.attributeName, this.assertionValue.getValue(), controls);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("CompareRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', attributeName='");
        buffer.append(this.attributeName);
        buffer.append("', assertionValue='");
        buffer.append(this.assertionValue.stringValue());
        buffer.append("')");
    }
}

